/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.AutoScalingHandler;
import org.apache.solr.cloud.autoscaling.ScheduledTriggers;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerTriggerThread
implements Runnable,
SolrCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCloudManager dataProvider;
    private final CloudConfig cloudConfig;
    private final ScheduledTriggers scheduledTriggers;
    private final AutoScaling.TriggerFactory triggerFactory;
    private final ReentrantLock updateLock = new ReentrantLock();
    private final Condition updated = this.updateLock.newCondition();
    private int znodeVersion = -1;
    private Map<String, AutoScaling.Trigger> activeTriggers = new HashMap<String, AutoScaling.Trigger>();
    private volatile boolean isClosed = false;
    private AutoScalingConfig autoScalingConfig;

    public OverseerTriggerThread(SolrResourceLoader loader, SolrCloudManager dataProvider, CloudConfig cloudConfig) {
        this.dataProvider = dataProvider;
        this.cloudConfig = cloudConfig;
        this.scheduledTriggers = new ScheduledTriggers(loader, dataProvider);
        this.triggerFactory = new AutoScaling.TriggerFactoryImpl(loader, dataProvider);
    }

    public void close() throws IOException {
        this.updateLock.lock();
        try {
            this.isClosed = true;
            this.activeTriggers.clear();
            this.updated.signalAll();
        }
        finally {
            this.updateLock.unlock();
        }
        IOUtils.closeQuietly((Closeable)this.triggerFactory);
        IOUtils.closeQuietly((Closeable)this.scheduledTriggers);
        log.debug("OverseerTriggerThread has been closed explicitly");
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int lastZnodeVersion = this.znodeVersion;
        while (!this.isClosed) {
            try {
                AutoScalingConfig autoScalingConfig = this.dataProvider.getDistribStateManager().getAutoScalingConfig();
                AutoScalingConfig withAutoAddReplicasTrigger = this.withAutoAddReplicasTrigger(autoScalingConfig);
                if (withAutoAddReplicasTrigger.equals((Object)autoScalingConfig)) break;
                log.debug("Adding .autoAddReplicas trigger");
                this.dataProvider.getDistribStateManager().setData("/autoscaling.json", Utils.toJSON((Object)withAutoAddReplicasTrigger), withAutoAddReplicasTrigger.getZkVersion());
                break;
            }
            catch (BadVersionException autoScalingConfig) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
                break;
            }
            catch (IOException | KeeperException e) {
                log.error("A ZK error has occurred", e);
            }
        }
        if (this.isClosed || Thread.currentThread().isInterrupted()) {
            return;
        }
        try {
            this.refreshAutoScalingConf(new AutoScalingWatcher());
        }
        catch (ConnectException e) {
            log.warn("ZooKeeper watch triggered for autoscaling conf, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
        }
        while (true) {
            List markers2;
            HashMap<String, AutoScaling.Trigger> copy = null;
            try {
                this.updateLock.lockInterruptibly();
                if (this.isClosed) {
                    log.warn("OverseerTriggerThread has been closed, exiting.");
                    break;
                }
                log.debug("Current znodeVersion {}, lastZnodeVersion {}", (Object)this.znodeVersion, (Object)lastZnodeVersion);
                try {
                    if (this.znodeVersion == lastZnodeVersion) {
                        this.updated.await();
                        if (this.isClosed) {
                            log.warn("OverseerTriggerThread woken up but we are closed, exiting.");
                            break;
                        }
                        if (this.znodeVersion == lastZnodeVersion) continue;
                    }
                    copy = new HashMap<String, AutoScaling.Trigger>(this.activeTriggers);
                    lastZnodeVersion = this.znodeVersion;
                    log.debug("Processed trigger updates upto znodeVersion {}", (Object)this.znodeVersion);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted", (Throwable)e);
                    break;
                }
                finally {
                    this.updateLock.unlock();
                    continue;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
                break;
            }
            this.scheduledTriggers.setAutoScalingConfig(this.autoScalingConfig);
            Set<String> managedTriggerNames = this.scheduledTriggers.getScheduledTriggerNames();
            for (String managedTriggerName : managedTriggerNames) {
                if (copy.containsKey(managedTriggerName)) continue;
                this.scheduledTriggers.remove(managedTriggerName);
            }
            boolean cleanOldNodeLostMarkers = true;
            boolean cleanOldNodeAddedMarkers = true;
            try {
                for (Map.Entry entry : copy.entrySet()) {
                    if (((AutoScaling.Trigger)entry.getValue()).getEventType().equals((Object)TriggerEventType.NODELOST)) {
                        cleanOldNodeLostMarkers = false;
                    }
                    if (((AutoScaling.Trigger)entry.getValue()).getEventType().equals((Object)TriggerEventType.NODEADDED)) {
                        cleanOldNodeAddedMarkers = false;
                    }
                    this.scheduledTriggers.add((AutoScaling.Trigger)entry.getValue());
                }
            }
            catch (AlreadyClosedException e) {
                if (this.isClosed) {
                    return;
                }
                throw new IllegalStateException("Caught AlreadyClosedException from ScheduledTriggers, but we're not closed yet!", e);
            }
            DistribStateManager stateManager = this.dataProvider.getDistribStateManager();
            if (cleanOldNodeLostMarkers) {
                log.debug("-- clean old nodeLost markers");
                try {
                    markers2 = stateManager.listData("/autoscaling/nodeLost");
                    markers2.forEach(n -> this.removeNodeMarker("/autoscaling/nodeLost", (String)n));
                }
                catch (NoSuchElementException markers2) {
                }
                catch (Exception e) {
                    log.warn("Error removing old nodeLost markers", (Throwable)e);
                }
            }
            if (!cleanOldNodeAddedMarkers) continue;
            log.debug("-- clean old nodeAdded markers");
            try {
                markers2 = stateManager.listData("/autoscaling/nodeAdded");
                markers2.forEach(n -> this.removeNodeMarker("/autoscaling/nodeAdded", (String)n));
            }
            catch (NoSuchElementException markers3) {
            }
            catch (Exception e) {
                log.warn("Error removing old nodeAdded markers", (Throwable)e);
            }
        }
    }

    private void removeNodeMarker(String path, String nodeName) {
        path = path + "/" + nodeName;
        try {
            this.dataProvider.getDistribStateManager().removeData(path, -1);
            log.debug("  -- deleted " + path);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            log.warn("Error removing old marker " + path, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAutoScalingConf(Watcher watcher) throws InterruptedException, IOException {
        this.updateLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            AutoScalingConfig currentConfig = this.dataProvider.getDistribStateManager().getAutoScalingConfig(watcher);
            log.debug("Refreshing {} with znode version {}", (Object)"/autoscaling.json", (Object)currentConfig.getZkVersion());
            if (this.znodeVersion >= currentConfig.getZkVersion()) {
                return;
            }
            this.autoScalingConfig = currentConfig;
            this.znodeVersion = this.autoScalingConfig.getZkVersion();
            Map<String, AutoScaling.Trigger> triggerMap = OverseerTriggerThread.loadTriggers(this.triggerFactory, this.autoScalingConfig);
            Set<String> trackingKeySet = this.activeTriggers.keySet();
            trackingKeySet.retainAll(triggerMap.keySet());
            for (Map.Entry<String, AutoScaling.Trigger> entry : triggerMap.entrySet()) {
                String triggerName = entry.getKey();
                AutoScaling.Trigger trigger = entry.getValue();
                if (trigger.isEnabled()) {
                    this.activeTriggers.put(triggerName, trigger);
                    continue;
                }
                this.activeTriggers.remove(triggerName);
            }
            this.updated.signalAll();
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private AutoScalingConfig withAutoAddReplicasTrigger(AutoScalingConfig autoScalingConfig) {
        Map<String, Object> triggerProps = AutoScaling.AUTO_ADD_REPLICAS_TRIGGER_PROPS;
        String triggerName = (String)triggerProps.get("name");
        Map configs = autoScalingConfig.getTriggerConfigs();
        for (AutoScalingConfig.TriggerConfig cfg : configs.values()) {
            if (!triggerName.equals(cfg.name)) continue;
            return autoScalingConfig;
        }
        triggerProps.computeIfPresent("waitFor", (k, v) -> (long)(this.cloudConfig.getAutoReplicaFailoverWaitAfterExpiration() / 1000));
        AutoScalingConfig.TriggerConfig config = new AutoScalingConfig.TriggerConfig(triggerName, triggerProps);
        autoScalingConfig = autoScalingConfig.withTriggerConfig(config);
        autoScalingConfig = AutoScalingHandler.withSystemLogListener(autoScalingConfig, triggerName);
        return autoScalingConfig;
    }

    private static Map<String, AutoScaling.Trigger> loadTriggers(AutoScaling.TriggerFactory triggerFactory, AutoScalingConfig autoScalingConfig) {
        Map triggers = autoScalingConfig.getTriggerConfigs();
        if (triggers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, AutoScaling.Trigger> triggerMap = new HashMap<String, AutoScaling.Trigger>(triggers.size());
        for (Map.Entry entry : triggers.entrySet()) {
            AutoScalingConfig.TriggerConfig cfg = (AutoScalingConfig.TriggerConfig)entry.getValue();
            TriggerEventType eventType = cfg.event;
            String triggerName = (String)entry.getKey();
            triggerMap.put(triggerName, triggerFactory.create(eventType, triggerName, cfg.properties));
        }
        return triggerMap;
    }

    class AutoScalingWatcher
    implements Watcher {
        AutoScalingWatcher() {
        }

        public void process(WatchedEvent watchedEvent) {
            if (Watcher.Event.EventType.None.equals((Object)watchedEvent.getType())) {
                return;
            }
            try {
                OverseerTriggerThread.this.refreshAutoScalingConf(this);
            }
            catch (ConnectException e) {
                log.warn("ZooKeeper watch triggered for autoscaling conf, but we cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
            }
        }
    }
}

