/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.concurrent.TimeUnit;

public class TimeOut {
    private final long timeoutAt;
    private final long startTime = System.nanoTime();

    public TimeOut(long interval, TimeUnit unit) {
        this.timeoutAt = this.startTime + TimeUnit.NANOSECONDS.convert(interval, unit);
    }

    public boolean hasTimedOut() {
        return System.nanoTime() > this.timeoutAt;
    }

    public long timeLeft(TimeUnit unit) {
        return unit.convert(this.timeoutAt - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public long timeElapsed(TimeUnit unit) {
        return unit.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
    }
}

