/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingClusterStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.SolrClientCloudManager;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;

public class PolicyHelper {
    private static ThreadLocal<Map<String, String>> policyMapping = new ThreadLocal();
    public static final int SESSION_EXPIRY = 180;
    public static ThreadLocal<Long> REF_VERSION = new ThreadLocal();
    public static ThreadLocal<SessionRef> SESSION_REF = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReplicaPosition> getReplicaLocations(String collName, AutoScalingConfig autoScalingConfig, SolrCloudManager cloudManager, final Map<String, String> optionalPolicyMapping, List<String> shardNames, int nrtReplicas, int tlogReplicas, int pullReplicas, List<String> nodesList) {
        ArrayList<ReplicaPosition> positions = new ArrayList<ReplicaPosition>();
        final DelegatingClusterStateProvider stateProvider = new DelegatingClusterStateProvider(cloudManager.getClusterStateProvider()){

            @Override
            public String getPolicyNameByCollection(String coll) {
                return policyMapping.get() != null && ((Map)policyMapping.get()).containsKey(coll) ? (String)optionalPolicyMapping.get(coll) : this.delegate.getPolicyNameByCollection(coll);
            }
        };
        DelegatingCloudManager delegatingManager = new DelegatingCloudManager(cloudManager){

            @Override
            public ClusterStateProvider getClusterStateProvider() {
                return stateProvider;
            }
        };
        policyMapping.set(optionalPolicyMapping);
        Policy.Session session = null;
        try {
            session = SESSION_REF.get() != null ? SESSION_REF.get().initOrGet(delegatingManager, autoScalingConfig.getPolicy()) : autoScalingConfig.getPolicy().createSession(delegatingManager);
            EnumMap<Replica.Type, Integer> typeVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
            typeVsCount.put(Replica.Type.NRT, nrtReplicas);
            typeVsCount.put(Replica.Type.TLOG, tlogReplicas);
            typeVsCount.put(Replica.Type.PULL, pullReplicas);
            for (String shardName : shardNames) {
                int idx = 0;
                for (Map.Entry e : typeVsCount.entrySet()) {
                    for (int i = 0; i < (Integer)e.getValue(); ++i) {
                        SolrRequest op;
                        Suggester suggester = session.getSuggester(CollectionParams.CollectionAction.ADDREPLICA).hint(Suggester.Hint.REPLICATYPE, e.getKey()).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(collName, shardName));
                        if (nodesList != null) {
                            for (String nodeName : nodesList) {
                                suggester = suggester.hint(Suggester.Hint.TARGET_NODE, nodeName);
                            }
                        }
                        if ((op = suggester.getSuggestion()) == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No node can satisfy the rules " + Utils.toJSONString(Utils.getDeepCopy(session.expandedClauses, 4, true)));
                        }
                        session = suggester.getSession();
                        positions.add(new ReplicaPosition(shardName, ++idx, (Replica.Type)((Object)e.getKey()), op.getParams().get("node")));
                    }
                }
            }
        }
        finally {
            if (session != null && SESSION_REF.get() != null) {
                PolicyHelper.SESSION_REF.get().updateSession(session);
            }
            policyMapping.remove();
        }
        return positions;
    }

    public static MapWriter getDiagnostics(Policy policy, SolrClientCloudManager cloudManager) {
        Policy.Session session = policy.createSession(cloudManager);
        List<Row> sorted = session.getSorted();
        List<Violation> violations = session.getViolations();
        List<Preference> clusterPreferences = policy.getClusterPreferences();
        ArrayList<Map<String, Object>> sortedNodes = new ArrayList<Map<String, Object>>(sorted.size());
        for (Row row : sorted) {
            Map<String, Object> map = Utils.makeMap("node", row.node);
            block1: for (Cell cell : row.getCells()) {
                for (Preference clusterPreference : clusterPreferences) {
                    Policy.SortParam name = clusterPreference.getName();
                    if (!cell.getName().equalsIgnoreCase(name.name())) continue;
                    map.put(name.name(), cell.getValue());
                    continue block1;
                }
            }
            sortedNodes.add(map);
        }
        return ew -> {
            ew.put("sortedNodes", sortedNodes);
            ew.put("violations", violations);
        };
    }

    public static List<Suggester.SuggestionInfo> getSuggestions(AutoScalingConfig autoScalingConf, SolrCloudManager cloudManager) {
        Policy policy = autoScalingConf.getPolicy();
        Suggestion.SuggestionCtx suggestionCtx = new Suggestion.SuggestionCtx();
        suggestionCtx.session = policy.createSession(cloudManager);
        List<Violation> violations = suggestionCtx.session.getViolations();
        for (Violation violation : violations) {
            Suggestion.ConditionType tagType = Suggestion.getTagType(violation.getClause().isPerCollectiontag() ? violation.getClause().tag.name : violation.getClause().globalTag.name);
            tagType.getSuggestions(suggestionCtx.setViolation(violation));
            suggestionCtx.violation = null;
        }
        return suggestionCtx.getSuggestions();
    }

    public static void clearFlagAndDecref(SessionRef policySessionRef) {
        Long refVersion = REF_VERSION.get();
        if (refVersion != null) {
            policySessionRef.decref(refVersion);
        }
        REF_VERSION.remove();
    }

    public static class SessionRef {
        private final AtomicLong myVersion = new AtomicLong(0L);
        AtomicInteger refCount = new AtomicInteger();
        private Policy.Session session;
        long lastUsedTime;

        public long getRefVersion() {
            return this.myVersion.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decref(long version) {
            Class<SessionRef> clazz = SessionRef.class;
            synchronized (SessionRef.class) {
                if (this.session == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                if (this.myVersion.get() != version) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                if (this.refCount.decrementAndGet() <= 0) {
                    this.session = null;
                    this.lastUsedTime = 0L;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        public int getRefCount() {
            return this.refCount.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Policy.Session get() {
            Class<SessionRef> clazz = SessionRef.class;
            synchronized (SessionRef.class) {
                if (this.session == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                if (TimeUnit.SECONDS.convert(System.nanoTime() - this.lastUsedTime, TimeUnit.NANOSECONDS) > 180L) {
                    this.session = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                REF_VERSION.set(this.myVersion.get());
                this.refCount.incrementAndGet();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.session;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Policy.Session initOrGet(SolrCloudManager cloudManager, Policy policy) {
            Class<SessionRef> clazz = SessionRef.class;
            synchronized (SessionRef.class) {
                Policy.Session session = this.get();
                if (session != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return session;
                }
                this.session = policy.createSession(cloudManager);
                this.myVersion.incrementAndGet();
                this.lastUsedTime = System.nanoTime();
                REF_VERSION.set(this.myVersion.get());
                this.refCount.set(1);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.session;
            }
        }

        private void updateSession(Policy.Session session) {
            this.session = session;
            this.lastUsedTime = System.nanoTime();
        }
    }
}

