/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MinMaxScaleEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MinMaxScaleEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (null == values) {
            return null;
        }
        double min = 0.0;
        double max = 1.0;
        if (values.length == 3) {
            min = ((Number)values[1]).doubleValue();
            max = ((Number)values[2]).doubleValue();
        }
        if (values[0] instanceof Matrix) {
            Matrix matrix = (Matrix)values[0];
            double[][] data = matrix.getData();
            double[][] scaled = new double[data.length][];
            for (int i = 0; i < scaled.length; ++i) {
                double[] row = data[i];
                scaled[i] = this.scale(row, min, max);
            }
            return new Matrix(scaled);
        }
        if (values[0] instanceof List) {
            List vec = (List)values[0];
            double[] data = new double[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                data[i] = ((Number)vec.get(i)).doubleValue();
            }
            data = this.scale(data, min, max);
            ArrayList<Double> scaled = new ArrayList<Double>(data.length);
            for (double d : data) {
                scaled.add(d);
            }
            return scaled;
        }
        throw new IOException();
    }

    private double[] scale(double[] values, double min, double max) {
        double localMin = Double.MAX_VALUE;
        double localMax = Double.MIN_VALUE;
        for (double d : values) {
            if (d > localMax) {
                localMax = d;
            }
            if (!(d < localMin)) continue;
            localMin = d;
        }
        double[] scaled = new double[values.length];
        for (int i = 0; i < scaled.length; ++i) {
            double s;
            double x = values[i];
            scaled[i] = s = (x - localMin) / (localMax - localMin);
        }
        if (min != 0.0 || max != 1.0) {
            double scale = max - min;
            for (int i = 0; i < scaled.length; ++i) {
                double d = scaled[i];
                scaled[i] = scale * d + min;
            }
        }
        return scaled;
    }
}

