/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TopicStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityStream
extends TupleStream
implements Expressible {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PushBackStream highPriorityTasks;
    private PushBackStream tasks;
    private TupleStream currentStream;

    public PriorityStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (2 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        TupleStream stream1 = factory.constructStream(streamExpressions.get(0));
        TupleStream stream2 = factory.constructStream(streamExpressions.get(1));
        if (!(stream1 instanceof TopicStream) || !(stream2 instanceof TopicStream)) {
            throw new IOException("The scheduler expects both stream parameters to be topics.");
        }
        this.init(new PushBackStream(stream1), new PushBackStream(stream2));
    }

    private void init(PushBackStream stream1, PushBackStream stream2) throws IOException {
        this.highPriorityTasks = stream1;
        this.tasks = stream2;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.highPriorityTasks instanceof Expressible)) {
                throw new IOException("The SchedulerStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            }
            expression.addParameter(this.highPriorityTasks.toExpression(factory));
            if (this.tasks instanceof Expressible) {
                expression.addParameter(this.tasks.toExpression(factory));
            } else {
                throw new IOException("The SchedulerStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.highPriorityTasks.toExplanation(factory), this.tasks.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.highPriorityTasks.setStreamContext(streamContext);
        this.tasks.setStreamContext(streamContext);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.highPriorityTasks);
        l.add(this.tasks);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.highPriorityTasks.open();
        Tuple tuple = this.highPriorityTasks.read();
        if (tuple.EOF) {
            this.highPriorityTasks.close();
            this.tasks.open();
            this.currentStream = this.tasks;
        } else {
            this.highPriorityTasks.pushBack(tuple);
            this.currentStream = this.highPriorityTasks;
        }
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        return this.currentStream.read();
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

