/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Clause
implements MapWriter,
Comparable<Clause> {
    final Map<String, Object> original;
    Condition collection;
    Condition shard;
    Condition replica;
    Condition tag;
    Condition globalTag;
    final Replica.Type type;
    boolean strict = true;
    private static final Set<String> IGNORE_TAGS = new HashSet<String>(Arrays.asList("replica", "collection", "shard", "strict", "type"));
    public static final String METRICS_PREFIX = "metrics:";

    public Clause(Map<String, Object> m) {
        List<String> ss;
        this.original = Utils.getDeepCopy(m, 10);
        String type = (String)m.get("type");
        this.type = type == null || "#ANY".equals(type) ? null : Replica.Type.valueOf(type.toUpperCase(Locale.ROOT));
        this.strict = Boolean.parseBoolean(String.valueOf(m.getOrDefault("strict", "true")));
        Optional<String> globalTagName = m.keySet().stream().filter(Policy.GLOBAL_ONLY_TAGS::contains).findFirst();
        if (globalTagName.isPresent()) {
            this.globalTag = this.parse(globalTagName.get(), m);
            if (m.size() > 2) {
                throw new RuntimeException("Only one extra tag supported for the tag " + globalTagName.get() + " in " + Utils.toJSONString(m));
            }
            this.tag = this.parse(m.keySet().stream().filter(s -> !((String)globalTagName.get()).equals(s) && !IGNORE_TAGS.contains(s)).findFirst().get(), m);
        } else {
            this.collection = this.parse("collection", m);
            this.shard = this.parse("shard", m);
            if (m.get("replica") == null) {
                throw new RuntimeException(StrUtils.formatString("'replica' is required in {0}", Utils.toJSONString(m)));
            }
            this.replica = this.parse("replica", m);
            if (this.replica.op == Operand.WILDCARD) {
                throw new RuntimeException("replica val cannot be null" + Utils.toJSONString(m));
            }
            m.forEach((s, o) -> this.parseCondition((String)s, o));
        }
        if (this.tag == null) {
            throw new RuntimeException("Invalid op, must have one and only one tag other than collection, shard,replica " + Utils.toJSONString(m));
        }
        if (this.tag.name.startsWith(METRICS_PREFIX) && ((ss = StrUtils.splitSmart(this.tag.name, ':')).size() < 3 || ss.size() > 4)) {
            throw new RuntimeException("Invalid metrics: param in " + Utils.toJSONString(m) + " must have at 2 or 3 segments after 'metrics:' separated by ':'");
        }
    }

    public boolean doesOverride(Clause that) {
        return this.collection.equals(that.collection) && this.tag.name.equals(that.tag.name);
    }

    public boolean isPerCollectiontag() {
        return this.globalTag == null;
    }

    void parseCondition(String s, Object o) {
        if (IGNORE_TAGS.contains(s)) {
            return;
        }
        if (this.tag != null) {
            throw new IllegalArgumentException("Only one tag other than collection, shard, replica is possible");
        }
        this.tag = this.parse(s, Collections.singletonMap(s, o));
    }

    private int compareTypes(Replica.Type t1, Replica.Type t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 != null && t2 == null) {
            return -1;
        }
        if (t1 == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Clause that) {
        int v = Integer.compare(this.tag.op.priority, that.tag.op.priority);
        if (v != 0) {
            return v;
        }
        if (this.isPerCollectiontag() && that.isPerCollectiontag()) {
            v = Integer.compare(this.replica.op.priority, that.replica.op.priority);
            if (v == 0) {
                v = Long.compare((Long)this.replica.val, (Long)that.replica.val);
                int n = v = this.replica.op == Operand.LESS_THAN ? v : v * -1;
            }
            if (v == 0) {
                v = this.compareTypes(this.type, that.type);
            }
            return v;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Clause that = (Clause)o;
        return this.compareTo(that) == 0;
    }

    void addTags(Collection<String> params) {
        if (this.globalTag != null && !params.contains(this.globalTag.name)) {
            params.add(this.globalTag.name);
        }
        if (this.tag != null && !params.contains(this.tag.name)) {
            params.add(this.tag.name);
        }
    }

    boolean isReplicaZero() {
        return this.replica != null && this.replica.getOperand() == Operand.EQUAL && 0L == (Long)this.replica.val;
    }

    Condition parse(String s, Map m) {
        Object expectedVal = null;
        Object val = m.get(s);
        try {
            String conditionName = s.trim();
            Operand operand = null;
            if (val == null) {
                operand = Operand.WILDCARD;
                expectedVal = "#ANY";
            } else if (val instanceof String) {
                String strVal = ((String)val).trim();
                operand = "#ANY".equals(strVal) || "#EACH".equals(strVal) ? Operand.WILDCARD : (strVal.startsWith(Operand.NOT_EQUAL.operand) ? Operand.NOT_EQUAL : (strVal.startsWith(Operand.GREATER_THAN.operand) ? Operand.GREATER_THAN : (strVal.startsWith(Operand.LESS_THAN.operand) ? Operand.LESS_THAN : Operand.EQUAL)));
                expectedVal = Clause.validate(s, strVal.substring(Operand.EQUAL == operand || Operand.WILDCARD == operand ? 0 : 1), true);
            } else if (val instanceof Number) {
                operand = Operand.EQUAL;
                expectedVal = Clause.validate(s, val, true);
            }
            return new Condition(conditionName, expectedVal, operand);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid tag : " + s + ":" + val, e);
        }
    }

    public List<Violation> test(List<Row> allRows) {
        Suggestion.ViolationCtx ctx = new Suggestion.ViolationCtx(this, allRows);
        if (this.isPerCollectiontag()) {
            Map<String, Map<String, Map<String, ReplicaCount>>> replicaCount = this.computeReplicaCounts(allRows);
            for (Map.Entry<String, Map<String, Map<String, ReplicaCount>>> e : replicaCount.entrySet()) {
                if (!this.collection.isPass(e.getKey())) continue;
                for (Map.Entry<String, Map<String, ReplicaCount>> shardVsCount : e.getValue().entrySet()) {
                    if (!this.shard.isPass(shardVsCount.getKey())) continue;
                    for (Map.Entry<String, ReplicaCount> counts : shardVsCount.getValue().entrySet()) {
                        if (this.replica.isPass(counts.getValue())) continue;
                        Violation violation = new Violation(this, e.getKey(), shardVsCount.getKey(), this.tag.name.equals("node") ? counts.getKey() : null, counts.getValue(), this.replica.delta(counts.getValue()), counts.getKey());
                        Suggestion.getTagType(this.tag.name).addViolatingReplicas(ctx.reset(counts.getKey(), counts.getValue(), violation));
                    }
                }
            }
        } else {
            for (Row r : allRows) {
                if (this.globalTag.isPass(r)) continue;
                Suggestion.ConditionType.CORES.addViolatingReplicas(ctx.reset(null, null, new Violation(this, null, null, r.node, r.getVal(this.globalTag.name), this.globalTag.delta(r.getVal(this.globalTag.name)), null)));
            }
        }
        return ctx.allViolations;
    }

    private Map<String, Map<String, Map<String, ReplicaCount>>> computeReplicaCounts(List<Row> allRows) {
        HashMap<String, Map<String, Map<String, ReplicaCount>>> collVsShardVsTagVsCount = new HashMap<String, Map<String, Map<String, ReplicaCount>>>();
        for (Row row : allRows) {
            block1: for (Map.Entry<String, Map<String, List<ReplicaInfo>>> colls : row.collectionVsShardVsReplicas.entrySet()) {
                String collectionName = colls.getKey();
                if (!this.collection.isPass(collectionName)) continue;
                Map collMap = collVsShardVsTagVsCount.computeIfAbsent(collectionName, s -> new HashMap());
                for (Map.Entry<String, List<ReplicaInfo>> shards : colls.getValue().entrySet()) {
                    String shardName = shards.getKey();
                    if ("#ANY".equals(this.shard.val)) {
                        shardName = "#ANY";
                    }
                    if (!this.shard.isPass(shardName)) continue block1;
                    Map tagVsCount = collMap.computeIfAbsent(shardName, s -> new HashMap());
                    Object tagVal = row.getVal(this.tag.name);
                    tagVsCount.computeIfAbsent(this.tag.isPass(tagVal) ? String.valueOf(tagVal) : "", s -> new ReplicaCount());
                    if (!this.tag.isPass(tagVal)) continue;
                    ((ReplicaCount)tagVsCount.get(String.valueOf(tagVal))).increment(shards.getValue());
                }
            }
        }
        return collVsShardVsTagVsCount;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String toString() {
        return Utils.toJSONString(this.original);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        for (Map.Entry<String, Object> e : this.original.entrySet()) {
            ew.put(e.getKey(), e.getValue());
        }
    }

    public static String parseString(Object val) {
        return val == null ? null : String.valueOf(val);
    }

    public static Object validate(String name, Object val, boolean isRuleVal) {
        if (val == null) {
            return null;
        }
        Suggestion.ConditionType info = Suggestion.getTagType(name);
        if (info == null) {
            throw new RuntimeException("Unknown type :" + name);
        }
        return info.validate(name, val, isRuleVal);
    }

    public static Long parseLong(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Long.parseLong(((String)val).trim());
            }
            catch (NumberFormatException e) {
                try {
                    num = Double.parseDouble((String)val);
                }
                catch (NumberFormatException e1) {
                    throw new RuntimeException(name + ": " + val + "not a valid number", e);
                }
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.longValue();
        }
        throw new RuntimeException(name + ": " + val + "not a valid number");
    }

    public static Double parseDouble(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(name + ": " + val + "not a valid number", e);
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.doubleValue();
        }
        throw new RuntimeException(name + ": " + val + "not a valid number");
    }

    static enum TestStatus {
        NOT_APPLICABLE,
        FAIL,
        PASS;

    }

    class Condition {
        final String name;
        final Object val;
        final Operand op;

        Condition(String name, Object val, Operand op) {
            this.name = name;
            this.val = val;
            this.op = op;
        }

        boolean isPass(Object inputVal) {
            Suggestion.ConditionType validator;
            if (inputVal instanceof ReplicaCount) {
                inputVal = ((ReplicaCount)inputVal).getVal(Clause.this.type);
            }
            if ((validator = Suggestion.getTagType(this.name)) == Suggestion.ConditionType.LAZY) {
                return this.op.match(Clause.parseString(this.val), Clause.parseString(inputVal)) == TestStatus.PASS;
            }
            return this.op.match(this.val, Clause.validate(this.name, inputVal, false)) == TestStatus.PASS;
        }

        boolean isPass(Row row) {
            return this.op.match(this.val, row.getVal(this.name)) == TestStatus.PASS;
        }

        public boolean equals(Object that) {
            if (that instanceof Condition) {
                Condition c = (Condition)that;
                return Objects.equals(c.name, this.name) && Objects.equals(c.val, this.val) && c.op == this.op;
            }
            return false;
        }

        public Long delta(Object val) {
            if (val instanceof ReplicaCount) {
                val = ((ReplicaCount)val).getVal(Clause.this.type);
            }
            if (this.val instanceof String) {
                if (this.op == Operand.LESS_THAN || this.op == Operand.GREATER_THAN) {
                    return this.op.opposite(Clause.this.isReplicaZero() && this == Clause.this.tag).delta(Clause.parseDouble(this.name, this.val), Clause.parseDouble(this.name, val));
                }
                return 0L;
            }
            return this.op.opposite(Clause.this.isReplicaZero() && this == Clause.this.tag).delta(this.val, val);
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.val;
        }

        public Operand getOperand() {
            return this.op;
        }
    }
}

