/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class StreamFactory
implements Serializable {
    private transient HashMap<String, String> collectionZkHosts = new HashMap();
    private transient HashMap<String, Class<? extends Expressible>> functionNames = new HashMap();
    private transient String defaultZkHost;
    private transient String defaultCollection;

    public StreamFactory withCollectionZkHost(String collectionName, String zkHost) {
        this.collectionZkHosts.put(collectionName, zkHost);
        this.defaultCollection = collectionName;
        return this;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public StreamFactory withDefaultZkHost(String zkHost) {
        this.defaultZkHost = zkHost;
        return this;
    }

    public String getDefaultZkHost() {
        return this.defaultZkHost;
    }

    public String getCollectionZkHost(String collectionName) {
        if (this.collectionZkHosts.containsKey(collectionName)) {
            return this.collectionZkHosts.get(collectionName);
        }
        return null;
    }

    public Map<String, Class<? extends Expressible>> getFunctionNames() {
        return this.functionNames;
    }

    public StreamFactory withFunctionName(String functionName, Class<? extends Expressible> clazz) {
        this.functionNames.put(functionName, clazz);
        return this;
    }

    public StreamExpressionParameter getOperand(StreamExpression expression, int parameterIndex) {
        if (null == expression.getParameters() || parameterIndex >= expression.getParameters().size()) {
            return null;
        }
        return expression.getParameters().get(parameterIndex);
    }

    public List<String> getValueOperands(StreamExpression expression) {
        return this.getOperandsOfType(expression, StreamExpressionValue.class).stream().map(item -> ((StreamExpressionValue)item).getValue()).collect(Collectors.toList());
    }

    public String getValueOperand(StreamExpression expression, int parameterIndex) {
        StreamExpressionParameter parameter = this.getOperand(expression, parameterIndex);
        if (null != parameter) {
            if (parameter instanceof StreamExpressionValue) {
                return ((StreamExpressionValue)parameter).getValue();
            }
            if (parameter instanceof StreamExpression) {
                return parameter.toString();
            }
        }
        return null;
    }

    public List<StreamExpressionNamedParameter> getNamedOperands(StreamExpression expression) {
        ArrayList<StreamExpressionNamedParameter> namedParameters = new ArrayList<StreamExpressionNamedParameter>();
        for (StreamExpressionParameter parameter : this.getOperandsOfType(expression, StreamExpressionNamedParameter.class)) {
            namedParameters.add((StreamExpressionNamedParameter)parameter);
        }
        return namedParameters;
    }

    public StreamExpressionNamedParameter getNamedOperand(StreamExpression expression, String name) {
        List<StreamExpressionNamedParameter> namedParameters = this.getNamedOperands(expression);
        for (StreamExpressionNamedParameter param : namedParameters) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public List<StreamExpression> getExpressionOperands(StreamExpression expression) {
        ArrayList<StreamExpression> namedParameters = new ArrayList<StreamExpression>();
        for (StreamExpressionParameter parameter : this.getOperandsOfType(expression, StreamExpression.class)) {
            namedParameters.add((StreamExpression)parameter);
        }
        return namedParameters;
    }

    public List<StreamExpression> getExpressionOperands(StreamExpression expression, String functionName) {
        ArrayList<StreamExpression> namedParameters = new ArrayList<StreamExpression>();
        for (StreamExpressionParameter parameter : this.getOperandsOfType(expression, StreamExpression.class)) {
            StreamExpression expressionOperand = (StreamExpression)parameter;
            if (!expressionOperand.getFunctionName().equals(functionName)) continue;
            namedParameters.add(expressionOperand);
        }
        return namedParameters;
    }

    public List<StreamExpressionParameter> getOperandsOfType(StreamExpression expression, Class ... clazzes) {
        ArrayList<StreamExpressionParameter> parameters = new ArrayList<StreamExpressionParameter>();
        block0: for (StreamExpressionParameter parameter : expression.getParameters()) {
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom(parameter.getClass())) continue block0;
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    public List<StreamExpression> getExpressionOperandsRepresentingTypes(StreamExpression expression, Class ... clazzes) {
        ArrayList<StreamExpression> matchingStreamExpressions = new ArrayList<StreamExpression>();
        List<StreamExpression> allStreamExpressions = this.getExpressionOperands(expression);
        block0: for (StreamExpression streamExpression : allStreamExpressions) {
            if (!this.functionNames.containsKey(streamExpression.getFunctionName())) continue;
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom(this.functionNames.get(streamExpression.getFunctionName()))) continue block0;
            }
            matchingStreamExpressions.add(streamExpression);
        }
        return matchingStreamExpressions;
    }

    public boolean doesRepresentTypes(StreamExpression expression, Class ... clazzes) {
        if (this.functionNames.containsKey(expression.getFunctionName())) {
            for (Class clazz : clazzes) {
                if (clazz.isAssignableFrom(this.functionNames.get(expression.getFunctionName()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getIntOperand(StreamExpression expression, String paramName, Integer defaultValue) throws IOException {
        StreamExpressionNamedParameter param = this.getNamedOperand(expression, paramName);
        if (null == param || null == param.getParameter() || !(param.getParameter() instanceof StreamExpressionValue)) {
            if (null != defaultValue) {
                return defaultValue;
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single '%s' parameter of type integer but didn't find one", expression, paramName));
        }
        String nStr = ((StreamExpressionValue)param.getParameter()).getValue();
        try {
            return Integer.parseInt(nStr);
        }
        catch (NumberFormatException e) {
            if (null != defaultValue) {
                return defaultValue;
            }
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - %s '%s' is not a valid integer.", expression, paramName, nStr));
        }
    }

    public boolean getBooleanOperand(StreamExpression expression, String paramName, Boolean defaultValue) throws IOException {
        StreamExpressionNamedParameter param = this.getNamedOperand(expression, paramName);
        if (null == param || null == param.getParameter() || !(param.getParameter() instanceof StreamExpressionValue)) {
            if (null != defaultValue) {
                return defaultValue;
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single '%s' parameter of type boolean but didn't find one", expression, paramName));
        }
        String nStr = ((StreamExpressionValue)param.getParameter()).getValue();
        return Boolean.parseBoolean(nStr);
    }

    public TupleStream constructStream(String expressionClause) throws IOException {
        return this.constructStream(StreamExpressionParser.parse(expressionClause));
    }

    public TupleStream constructStream(StreamExpression expression) throws IOException {
        Class<? extends Expressible> clazz;
        String function = expression.getFunctionName();
        if (this.functionNames.containsKey(function) && Expressible.class.isAssignableFrom(clazz = this.functionNames.get(function)) && TupleStream.class.isAssignableFrom(clazz)) {
            return (TupleStream)((Object)this.createInstance(this.functionNames.get(function), new Class[]{StreamExpression.class, StreamFactory.class}, new Object[]{expression, this}));
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid stream expression %s - function '%s' is unknown (not mapped to a valid TupleStream)", expression, expression.getFunctionName()));
    }

    public Metric constructMetric(String expressionClause) throws IOException {
        return this.constructMetric(StreamExpressionParser.parse(expressionClause));
    }

    public Metric constructMetric(StreamExpression expression) throws IOException {
        Class<? extends Expressible> clazz;
        String function = expression.getFunctionName();
        if (this.functionNames.containsKey(function) && Expressible.class.isAssignableFrom(clazz = this.functionNames.get(function)) && Metric.class.isAssignableFrom(clazz)) {
            return (Metric)this.createInstance(this.functionNames.get(function), new Class[]{StreamExpression.class, StreamFactory.class}, new Object[]{expression, this});
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid metric expression %s - function '%s' is unknown (not mapped to a valid Metric)", expression, expression.getFunctionName()));
    }

    public StreamComparator constructComparator(String comparatorString, Class comparatorType) throws IOException {
        if (comparatorString.contains(",")) {
            String[] parts = comparatorString.split(",");
            StreamComparator[] comps = new StreamComparator[parts.length];
            for (int idx = 0; idx < parts.length; ++idx) {
                comps[idx] = this.constructComparator(parts[idx].trim(), comparatorType);
            }
            return new MultipleFieldComparator(comps);
        }
        if (comparatorString.contains("=")) {
            String[] parts = comparatorString.split("[ =]");
            if (parts.length < 3) {
                throw new IOException(String.format(Locale.ROOT, "Invalid comparator expression %s - expecting 'left=right order'", comparatorString));
            }
            String leftFieldName = null;
            String rightFieldName = null;
            String order = null;
            for (String part : parts) {
                if (null == part || 0 == part.trim().length()) continue;
                if (null == leftFieldName) {
                    leftFieldName = part.trim();
                    continue;
                }
                if (null == rightFieldName) {
                    rightFieldName = part.trim();
                    continue;
                }
                order = part.trim();
                break;
            }
            if (null == leftFieldName || null == rightFieldName || null == order) {
                throw new IOException(String.format(Locale.ROOT, "Invalid comparator expression %s - expecting 'left=right order'", comparatorString));
            }
            return (StreamComparator)this.createInstance(comparatorType, new Class[]{String.class, String.class, ComparatorOrder.class}, new Object[]{leftFieldName, rightFieldName, ComparatorOrder.fromString(order)});
        }
        String[] parts = comparatorString.split(" ");
        if (2 != parts.length) {
            throw new IOException(String.format(Locale.ROOT, "Invalid comparator expression %s - expecting 'field order'", comparatorString));
        }
        String fieldName = parts[0].trim();
        String order = parts[1].trim();
        return (StreamComparator)this.createInstance(comparatorType, new Class[]{String.class, ComparatorOrder.class}, new Object[]{fieldName, ComparatorOrder.fromString(order)});
    }

    public StreamEqualitor constructEqualitor(String equalitorString, Class equalitorType) throws IOException {
        String rightFieldName;
        String leftFieldName;
        if (equalitorString.contains(",")) {
            String[] parts = equalitorString.split(",");
            StreamEqualitor[] eqs = new StreamEqualitor[parts.length];
            for (int idx = 0; idx < parts.length; ++idx) {
                eqs[idx] = this.constructEqualitor(parts[idx].trim(), equalitorType);
            }
            return new MultipleFieldEqualitor(eqs);
        }
        if (equalitorString.contains("=")) {
            String[] parts = equalitorString.split("=");
            if (2 != parts.length) {
                throw new IOException(String.format(Locale.ROOT, "Invalid equalitor expression %s - expecting fieldName=fieldName", equalitorString));
            }
            leftFieldName = parts[0].trim();
            rightFieldName = parts[1].trim();
        } else {
            leftFieldName = rightFieldName = equalitorString.trim();
        }
        return (StreamEqualitor)this.createInstance(equalitorType, new Class[]{String.class, String.class}, new Object[]{leftFieldName, rightFieldName});
    }

    public Metric constructOperation(String expressionClause) throws IOException {
        return this.constructMetric(StreamExpressionParser.parse(expressionClause));
    }

    public StreamOperation constructOperation(StreamExpression expression) throws IOException {
        Class<? extends Expressible> clazz;
        String function = expression.getFunctionName();
        if (this.functionNames.containsKey(function) && Expressible.class.isAssignableFrom(clazz = this.functionNames.get(function)) && StreamOperation.class.isAssignableFrom(clazz)) {
            return (StreamOperation)this.createInstance(this.functionNames.get(function), new Class[]{StreamExpression.class, StreamFactory.class}, new Object[]{expression, this});
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid operation expression %s - function '%s' is unknown (not mapped to a valid StreamOperation)", expression, expression.getFunctionName()));
    }

    public StreamEvaluator constructEvaluator(String expressionClause) throws IOException {
        return this.constructEvaluator(StreamExpressionParser.parse(expressionClause));
    }

    public StreamEvaluator constructEvaluator(StreamExpression expression) throws IOException {
        Class<? extends Expressible> clazz;
        String function = expression.getFunctionName();
        if (this.functionNames.containsKey(function) && Expressible.class.isAssignableFrom(clazz = this.functionNames.get(function)) && StreamEvaluator.class.isAssignableFrom(clazz)) {
            return (StreamEvaluator)this.createInstance(this.functionNames.get(function), new Class[]{StreamExpression.class, StreamFactory.class}, new Object[]{expression, this});
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid evaluator expression %s - function '%s' is unknown (not mapped to a valid StreamEvaluator)", expression, expression.getFunctionName()));
    }

    public boolean isStream(StreamExpression expression) throws IOException {
        Class<? extends Expressible> clazz;
        String function = expression.getFunctionName();
        return this.functionNames.containsKey(function) && Expressible.class.isAssignableFrom(clazz = this.functionNames.get(function)) && TupleStream.class.isAssignableFrom(clazz);
    }

    public boolean isEvaluator(StreamExpression expression) throws IOException {
        Class<? extends Expressible> clazz;
        String function = expression.getFunctionName();
        return this.functionNames.containsKey(function) && Expressible.class.isAssignableFrom(clazz = this.functionNames.get(function)) && StreamEvaluator.class.isAssignableFrom(clazz);
    }

    public <T> T createInstance(Class<T> clazz, Class<?>[] paramTypes, Object[] params) throws IOException {
        try {
            Constructor<T> ctor = clazz.getConstructor(paramTypes);
            return ctor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            if (null != e.getMessage()) {
                throw new IOException(String.format(Locale.ROOT, "Unable to construct instance of %s caused by %s", clazz.getName(), e.getMessage()), e);
            }
            throw new IOException(String.format(Locale.ROOT, "Unable to construct instance of %s", clazz.getName()), e);
        }
    }

    public String getFunctionName(Class<? extends Expressible> clazz) throws IOException {
        for (Map.Entry<String, Class<? extends Expressible>> entry : this.functionNames.entrySet()) {
            if (entry.getValue() != clazz) continue;
            return entry.getKey();
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to find function name for class '%s'", clazz.getName()));
    }

    public Object constructPrimitiveObject(String original) {
        String lower = original.trim().toLowerCase(Locale.ROOT);
        if ("null".equals(lower)) {
            return null;
        }
        if ("true".equals(lower) || "false".equals(lower)) {
            return Boolean.parseBoolean(lower);
        }
        try {
            return Long.valueOf(original);
        }
        catch (Exception exception) {
            try {
                if (original.matches(".{1,8}")) {
                    return Double.valueOf(original);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (original.matches(".{1,17}")) {
                    return Double.valueOf(original);
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return original;
        }
    }
}

