/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XmlCasDeserializer {
    public static void deserialize(InputStream aStream, CAS aCAS) throws SAXException, IOException {
        XmlCasDeserializer.deserialize(aStream, aCAS, false);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XmlCasDeserializerHandler handler = new XmlCasDeserializerHandler(aCAS, aLenient);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(aStream));
    }

    static class XmlCasDeserializerHandler
    extends DefaultHandler {
        private CAS mCAS;
        private boolean mLenient;
        private ContentHandler mDelegateHandler;

        XmlCasDeserializerHandler(CAS cas, boolean lenient) {
            this.mCAS = cas;
            this.mLenient = lenient;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.mDelegateHandler == null) {
                String xmiVer = attributes.getValue("xmi:version");
                if (xmiVer != null && xmiVer.length() > 0) {
                    XmiCasDeserializer deser = new XmiCasDeserializer(this.mCAS.getTypeSystem());
                    this.mDelegateHandler = deser.getXmiCasHandler(this.mCAS, this.mLenient);
                } else if ("CAS".equals(localName)) {
                    XCASDeserializer deser = new XCASDeserializer(this.mCAS.getTypeSystem());
                    this.mDelegateHandler = deser.getXCASHandler(this.mCAS, this.mLenient ? new OutOfTypeSystemData() : null);
                } else {
                    XmiCasDeserializer deser = new XmiCasDeserializer(this.mCAS.getTypeSystem());
                    this.mDelegateHandler = deser.getXmiCasHandler(this.mCAS, this.mLenient);
                }
                this.mDelegateHandler.startDocument();
            }
            this.mDelegateHandler.startElement(uri, localName, qName, attributes);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mDelegateHandler.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
            this.mDelegateHandler.endDocument();
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.mDelegateHandler.endElement(uri, localName, qName);
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

