/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.util.IOUtils;

public final class OwnCacheKeyMultiReader
extends MultiReader {
    private final Set<IndexReader.ClosedListener> readerClosedListeners = new CopyOnWriteArraySet<IndexReader.ClosedListener>();
    private final IndexReader.CacheHelper cacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        public void addClosedListener(IndexReader.ClosedListener listener) {
            OwnCacheKeyMultiReader.this.ensureOpen();
            OwnCacheKeyMultiReader.this.readerClosedListeners.add(listener);
        }
    };

    public OwnCacheKeyMultiReader(IndexReader ... subReaders) throws IOException {
        super(subReaders);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.cacheHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyReaderClosedListeners(Throwable th) throws IOException {
        Set<IndexReader.ClosedListener> set = this.readerClosedListeners;
        synchronized (set) {
            for (IndexReader.ClosedListener listener : this.readerClosedListeners) {
                try {
                    listener.onClose(this.cacheHelper.getKey());
                }
                catch (Throwable t) {
                    if (th == null) {
                        th = t;
                        continue;
                    }
                    th.addSuppressed(t);
                }
            }
            if (th != null) {
                throw IOUtils.rethrowAlways((Throwable)th);
            }
        }
    }
}

