/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.InstalledUpdateProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledModuleProvider
implements InstalledUpdateProvider {
    private static InstalledModuleProvider DEFAULT;
    private LookupListener lkpListener;
    private Lookup.Result<ModuleInfo> result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
    private Map<String, ModuleInfo> moduleInfos;

    public static Map<String, ModuleInfo> getInstalledModules() {
        return InstalledModuleProvider.getDefault().getModuleInfos(false);
    }

    private Map<String, ModuleInfo> getModuleInfos(boolean bl) {
        if (this.moduleInfos == null || bl) {
            this.moduleInfos = new HashMap<String, ModuleInfo>();
            Collection<ModuleInfo> collection = Collections.unmodifiableCollection(this.result.allInstances());
            for (ModuleInfo moduleInfo : collection) {
                this.moduleInfos.put(moduleInfo.getCodeNameBase(), moduleInfo);
            }
        }
        assert (this.moduleInfos != null);
        return this.moduleInfos;
    }

    public static InstalledModuleProvider getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new InstalledModuleProvider();
        }
        return DEFAULT;
    }

    private InstalledModuleProvider() {
        this.lkpListener = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                InstalledModuleProvider.this.moduleInfos = null;
            }
        };
        this.result.addLookupListener(this.lkpListener);
    }

    @Override
    public String getName() {
        return "installed-module-provider";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        for (ModuleInfo moduleInfo : this.getModuleInfos(true).values()) {
            Date date = null;
            String string = null;
            if (date != null) {
                string = Utilities.formatDate(date);
            }
            InstalledModuleItem installedModuleItem = new InstalledModuleItem(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion() == null ? null : moduleInfo.getSpecificationVersion().toString(), moduleInfo, null, null, string);
            UpdateItem updateItem = Utilities.createUpdateItem(installedModuleItem);
            hashMap.put(moduleInfo.getCodeName() + '_' + moduleInfo.getSpecificationVersion(), updateItem);
        }
        return hashMap;
    }

    @Override
    public boolean refresh(boolean bl) throws IOException {
        if (this.moduleInfos == null) {
            this.moduleInfos = new HashMap<String, ModuleInfo>();
            Collection collection = this.result.allInstances();
            for (ModuleInfo moduleInfo : collection) {
                this.moduleInfos.put(moduleInfo.getCodeNameBase(), moduleInfo);
            }
        }
        assert (this.moduleInfos != null);
        return true;
    }

    @Override
    public UpdateUnitProvider.CATEGORY getCategory() {
        return UpdateUnitProvider.CATEGORY.COMMUNITY;
    }
}

