/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.loom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.ApplicationEvent;
import org.apache.avalon.phoenix.ApplicationListener;
import org.apache.avalon.phoenix.BlockEvent;
import org.apache.avalon.phoenix.metainfo.BlockInfo;
import org.apache.avalon.phoenix.metainfo.ServiceDescriptor;
import org.codehaus.xfire.loom.ServiceDeployer;

public class XFireBlockDeployerApplicationListener
extends AbstractLogEnabled
implements ApplicationListener,
Configurable {
    private ServiceDeployer m_deployer;
    private Map m_services;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] kids = configuration.getChildren("service");
        this.m_services = new HashMap(kids.length);
        for (int i = 0; i < kids.length; ++i) {
            this.m_services.put(kids[i].getValue(), null);
        }
    }

    public void applicationFailure(Exception e) {
    }

    public void applicationStarted() {
        if (null == this.m_deployer) {
            throw new IllegalStateException("Must provide a " + ServiceDeployer.class.getName());
        }
        Iterator i = this.m_services.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (null == entry.getValue()) {
                throw new IllegalStateException("Unable to deploy configured service: " + entry.getKey());
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Deploying '" + entry.getKey() + "'");
            }
            try {
                this.m_deployer.deploy((String)entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to deploy '" + entry.getKey() + "'", e);
            }
        }
    }

    public void applicationStarting(ApplicationEvent event) throws Exception {
    }

    public void applicationStopped() {
    }

    public void applicationStopping() {
        Iterator i = this.m_services.keySet().iterator();
        while (i.hasNext()) {
            String service = (String)i.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Undeploying '" + service + "'");
            }
            this.m_deployer.undeploy(service);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void blockAdded(BlockEvent event) {
        if (this.isServiceDeployer(event.getBlockInfo())) {
            if (null != this.m_deployer) throw new RuntimeException("Duplicate ServiceDeployer found: " + event.getName());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using '" + event.getName() + "' as ServiceDeployer");
            }
            this.m_deployer = (ServiceDeployer)event.getObject();
            return;
        } else {
            if (!this.m_services.containsKey(event.getName())) return;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Marking '" + event.getName() + "' for XFire deploment");
            }
            this.m_services.put(event.getName(), event.getObject());
        }
    }

    private boolean isServiceDeployer(BlockInfo blockInfo) {
        ServiceDescriptor[] services = blockInfo.getServices();
        for (int i = 0; i < services.length; ++i) {
            if (!(class$org$codehaus$xfire$loom$ServiceDeployer == null ? XFireBlockDeployerApplicationListener.class$("org.codehaus.xfire.loom.ServiceDeployer") : class$org$codehaus$xfire$loom$ServiceDeployer).getName().equals(services[i].getName())) continue;
            return true;
        }
        return false;
    }

    public void blockRemoved(BlockEvent event) {
    }
}

