/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.script.ScriptException;

public abstract class PainlessScript {
    private final String name;
    private final String source;
    private final BitSet statements;

    protected PainlessScript(String name, String source, BitSet statements) {
        this.name = name;
        this.source = source;
        this.statements = statements;
    }

    protected final ScriptException convertToScriptException(Throwable t, Map<String, List<String>> extraMetadata) {
        ArrayList<String> scriptStack = new ArrayList<String>();
        for (StackTraceElement element : t.getStackTrace()) {
            if (WriterConstants.CLASS_NAME.equals(element.getClassName())) {
                int endOffset;
                int startOffset;
                int offset = element.getLineNumber();
                if (offset == -1) {
                    scriptStack.add("<<< unknown portion of script >>>");
                    break;
                }
                if ((startOffset = this.getPreviousStatement(--offset)) == -1) {
                    assert (false);
                    startOffset = 0;
                }
                if ((endOffset = this.getNextStatement(startOffset)) == -1) {
                    endOffset = this.source.length();
                }
                String snippet = this.source.substring(startOffset, endOffset);
                scriptStack.add(snippet);
                StringBuilder pointer = new StringBuilder();
                for (int i = startOffset; i < offset; ++i) {
                    pointer.append(' ');
                }
                pointer.append("^---- HERE");
                scriptStack.add(pointer.toString());
                break;
            }
            if (PainlessScript.shouldFilter(element)) continue;
            scriptStack.add(element.toString());
        }
        String name = "<inline>".equals(this.name) ? this.source : this.name;
        ScriptException scriptException = new ScriptException("runtime error", t, scriptStack, name, "painless");
        for (Map.Entry<String, List<String>> entry : extraMetadata.entrySet()) {
            scriptException.addMetadata(entry.getKey(), entry.getValue());
        }
        return scriptException;
    }

    private static boolean shouldFilter(StackTraceElement element) {
        return element.getClassName().startsWith("org.elasticsearch.painless.") || element.getClassName().startsWith("java.lang.invoke.") || element.getClassName().startsWith("sun.invoke.");
    }

    private int getPreviousStatement(int offset) {
        return this.statements.previousSetBit(offset);
    }

    private int getNextStatement(int offset) {
        return this.statements.nextSetBit(offset + 1);
    }
}

