/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.security.DomainCombiner;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.LinkedList;
import javax.security.auth.Subject;

public class SubjectDomainCombiner
implements DomainCombiner {
    private final Subject subject;

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
    }

    public ProtectionDomain[] combine(ProtectionDomain[] current, ProtectionDomain[] assigned) {
        int i;
        LinkedList<ProtectionDomain> domains = new LinkedList<ProtectionDomain>();
        Principal[] principals = null;
        if (this.subject != null) {
            principals = this.subject.getPrincipals().toArray(new Principal[0]);
        }
        if (current != null) {
            i = 0;
            while (i < current.length) {
                domains.add(new ProtectionDomain(current[i].getCodeSource(), current[i].getPermissions(), current[i].getClassLoader(), principals));
                ++i;
            }
        }
        if (assigned != null) {
            i = 0;
            while (i < assigned.length) {
                domains.add(assigned[i]);
                ++i;
            }
        }
        return domains.toArray((S[])new ProtectionDomain[domains.size()]);
    }

    public Subject getSubject() {
        return this.subject;
    }
}

