/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EditableAtEndDocument
extends PlainDocument {
    private int mark;

    @Override
    public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
        int len = this.getLength();
        super.insertString(len, text, a);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        int start = offs;
        int end = offs + len;
        int markStart = this.mark;
        int markEnd = this.getLength();
        if (end < markStart || start > markEnd) {
            return;
        }
        int cutStart = Math.max(start, markStart);
        int cutEnd = Math.min(end, markEnd);
        super.remove(cutStart, cutEnd - cutStart);
    }

    public void setMark() {
        this.mark = this.getLength();
    }

    public String getMarkedText() throws BadLocationException {
        return this.getText(this.mark, this.getLength() - this.mark);
    }

    public void clear() {
        try {
            super.remove(0, this.getLength());
            this.setMark();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

