/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class DistributeAction
extends JosmAction {
    public DistributeAction() {
        super(I18n.tr("Distribute Nodes", new Object[0]), "distribute", I18n.tr("Distribute the selected nodes to equal distances along a line.", new Object[0]), Shortcut.registerShortcut("tools:distribute", I18n.tr("Tool: {0}", I18n.tr("Distribute Nodes", new Object[0])), 66, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/DistributeNodes"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<Command> cmds;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> selected = this.getLayerManager().getEditDataSet().getSelected();
        LinkedList<Way> ways = new LinkedList<Way>();
        HashSet<Node> nodes = new HashSet<Node>();
        for (OsmPrimitive osm : selected) {
            if (osm instanceof Node) {
                nodes.add((Node)osm);
                continue;
            }
            if (!(osm instanceof Way)) continue;
            ways.add((Way)osm);
        }
        Set<Node> ignoredNodes = DistributeAction.removeNodesWithoutCoordinates(nodes);
        if (!ignoredNodes.isEmpty()) {
            Logging.warn(I18n.tr("Ignoring {0} nodes with null coordinates", ignoredNodes.size()));
            ignoredNodes.clear();
        }
        if (DistributeAction.checkDistributeWay(ways, nodes)) {
            cmds = DistributeAction.distributeWay(ways, nodes);
        } else if (DistributeAction.checkDistributeNodes(ways, nodes).booleanValue()) {
            cmds = DistributeAction.distributeNodes(nodes);
        } else {
            new Notification(I18n.tr("Please select :\n* One no self-crossing way with at most two of its nodes;\n* Three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        if (cmds.isEmpty()) {
            return;
        }
        MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Distribute Nodes", new Object[0]), cmds));
    }

    private static boolean checkDistributeWay(Collection<Way> ways, Collection<Node> nodes) {
        if (ways.size() == 1 && nodes.size() <= 2) {
            Way w = ways.iterator().next();
            HashSet<Node> unduplicated = new HashSet<Node>(w.getNodes());
            if (unduplicated.size() != w.getNodesCount()) {
                return false;
            }
            for (Node node : nodes) {
                if (w.containsNode(node)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Collection<Command> distributeWay(Collection<Way> ways, Collection<Node> nodes) {
        double dy;
        double dx;
        double ya;
        double xa;
        Way w = ways.iterator().next();
        LinkedList<Command> cmds = new LinkedList<Command>();
        if (w.getNodesCount() == nodes.size() || w.getNodesCount() <= 2) {
            return cmds;
        }
        if (nodes.isEmpty()) {
            Node na = w.firstNode();
            nodes.add(na);
            Node nb = w.lastNode();
            nodes.add(nb);
            xa = na.getEastNorth().east();
            ya = na.getEastNorth().north();
            dx = (nb.getEastNorth().east() - xa) / (double)(w.getNodesCount() - 1);
            dy = (nb.getEastNorth().north() - ya) / (double)(w.getNodesCount() - 1);
        } else if (nodes.size() == 1) {
            Node n = nodes.iterator().next();
            int nIdx = w.getNodes().indexOf(n);
            Node na = w.firstNode();
            Node nb = w.lastNode();
            dx = (nb.getEastNorth().east() - na.getEastNorth().east()) / (double)(w.getNodesCount() - 1);
            dy = (nb.getEastNorth().north() - na.getEastNorth().north()) / (double)(w.getNodesCount() - 1);
            xa = n.getEastNorth().east() - dx * (double)nIdx;
            ya = n.getEastNorth().north() - dy * (double)nIdx;
        } else {
            Iterator<Node> it = nodes.iterator();
            Node na = it.next();
            Node nb = it.next();
            List<Node> wayNodes = w.getNodes();
            int naIdx = wayNodes.indexOf(na);
            int nbIdx = wayNodes.indexOf(nb);
            dx = (nb.getEastNorth().east() - na.getEastNorth().east()) / (double)(nbIdx - naIdx);
            dy = (nb.getEastNorth().north() - na.getEastNorth().north()) / (double)(nbIdx - naIdx);
            xa = na.getEastNorth().east() - dx * (double)naIdx;
            ya = na.getEastNorth().north() - dy * (double)naIdx;
        }
        for (int i = 0; i < w.getNodesCount(); ++i) {
            Node n = w.getNode(i);
            if (!n.isLatLonKnown() || nodes.contains(n)) continue;
            double x = xa + (double)i * dx;
            double y = ya + (double)i * dy;
            cmds.add(new MoveCommand((OsmPrimitive)n, x - n.getEastNorth().east(), y - n.getEastNorth().north()));
        }
        return cmds;
    }

    private static Boolean checkDistributeNodes(Collection<Way> ways, Collection<Node> nodes) {
        return ways.isEmpty() && nodes.size() >= 3;
    }

    private static Collection<Command> distributeNodes(Collection<Node> nodes) {
        double distance = Double.NEGATIVE_INFINITY;
        Node nodea = null;
        Node nodeb = null;
        LinkedList<Node> itnodes = new LinkedList<Node>(nodes);
        for (Node n : nodes) {
            itnodes.remove(n);
            for (Node m : itnodes) {
                double dist = Math.sqrt(n.getEastNorth().distance(m.getEastNorth()));
                if (!(dist > distance)) continue;
                nodea = n;
                nodeb = m;
                distance = dist;
            }
        }
        if (nodea == null || nodeb == null) {
            throw new IllegalArgumentException();
        }
        nodes.remove(nodea);
        nodes.remove(nodeb);
        double ax = nodea.getEastNorth().east();
        double ay = nodea.getEastNorth().north();
        double bx = nodeb.getEastNorth().east();
        double by = nodeb.getEastNorth().north();
        LinkedList<Command> cmds = new LinkedList<Command>();
        int num = nodes.size() + 1;
        int pos = 0;
        while (!nodes.isEmpty()) {
            ++pos;
            Node s = null;
            distance = Double.NEGATIVE_INFINITY;
            for (Node n : nodes) {
                double dist = Math.sqrt(nodeb.getEastNorth().distance(n.getEastNorth()));
                if (!(dist > distance)) continue;
                s = n;
                distance = dist;
            }
            if (s == null) continue;
            double dx = ax - s.getEastNorth().east() + (bx - ax) * (double)pos / (double)num;
            double dy = ay - s.getEastNorth().north() + (by - ay) * (double)pos / (double)num;
            cmds.add(new MoveCommand((OsmPrimitive)s, dx, dy));
            nodes.remove(s);
        }
        return cmds;
    }

    private static Set<Node> removeNodesWithoutCoordinates(Collection<Node> col) {
        HashSet<Node> result = new HashSet<Node>();
        Iterator<Node> it = col.iterator();
        while (it.hasNext()) {
            Node n = it.next();
            if (n.isLatLonKnown()) continue;
            it.remove();
            result.add(n);
        }
        return result;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }
}

