/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class NTV2Datum
extends AbstractDatum {
    private final NTV2GridShiftFileWrapper nadgrids;

    public NTV2Datum(String name, String proj4Id, Ellipsoid ellps, NTV2GridShiftFileWrapper nadgrids) {
        super(name, proj4Id, ellps);
        this.nadgrids = nadgrids;
    }

    @Override
    public LatLon toWGS84(LatLon ll) {
        NTV2GridShift gs = new NTV2GridShift(ll);
        try {
            this.nadgrids.getShiftFile().gridShiftForward(gs);
            return new LatLon(ll.lat() + gs.getLatShiftDegrees(), ll.lon() + gs.getLonShiftPositiveEastDegrees());
        }
        catch (IOException e) {
            throw new JosmRuntimeException(e);
        }
    }

    @Override
    public LatLon fromWGS84(LatLon ll) {
        NTV2GridShift gs = new NTV2GridShift(ll);
        try {
            this.nadgrids.getShiftFile().gridShiftReverse(gs);
            return new LatLon(ll.lat() + gs.getLatShiftDegrees(), ll.lon() + gs.getLonShiftPositiveEastDegrees());
        }
        catch (IOException e) {
            throw new JosmRuntimeException(e);
        }
    }
}

