/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed;

import java.util.HashMap;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public abstract class ConstantsResolveHandler
implements ResolveHandler {
    private static final StyleKey[] EMPTY_STYLE_KEYS = new StyleKey[0];
    private HashMap constants = new HashMap();
    private CSSValue fallback;

    protected ConstantsResolveHandler() {
    }

    public CSSValue getFallback() {
        return this.fallback;
    }

    protected void setFallback(CSSValue cSSValue) {
        this.fallback = cSSValue;
    }

    protected CSSValue lookupValue(CSSConstant cSSConstant) {
        return (CSSValue)this.constants.get(cSSConstant);
    }

    protected void addValue(CSSConstant cSSConstant, CSSValue cSSValue) {
        this.constants.put(cSSConstant, cSSValue);
    }

    protected void addNormalizeValue(CSSConstant cSSConstant) {
        this.constants.put(cSSConstant, cSSConstant);
    }

    public StyleKey[] getRequiredStyles() {
        return EMPTY_STYLE_KEYS;
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSValue cSSValue = this.resolveValue(layoutProcess, layoutElement, styleKey);
        if (cSSValue != null) {
            layoutElement.getLayoutContext().setValue(styleKey, cSSValue);
        }
    }

    protected CSSValue resolveValue(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (!(cSSValue instanceof CSSConstant)) {
            CSSValue cSSValue2 = this.getFallback();
            if (cSSValue2 != null) {
                return cSSValue2;
            }
            return null;
        }
        CSSConstant cSSConstant = (CSSConstant)cSSValue;
        CSSValue cSSValue3 = this.lookupValue(cSSConstant);
        if (cSSValue3 != null) {
            return cSSValue3;
        }
        CSSValue cSSValue4 = this.getFallback();
        if (cSSValue4 != null) {
            return cSSValue4;
        }
        return null;
    }
}

