/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectFileProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.ui.ItemEx;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.netbeans.spi.jumpto.file.FileProvider;
import org.netbeans.spi.jumpto.file.FileProviderFactory;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;

public class MakeProjectFileProviderFactory
extends MakeProjectFileProvider
implements FileProviderFactory {
    private static final Logger LOG = Logger.getLogger(MakeProjectFileProviderFactory.class.getName());

    public String name() {
        return "CND FileProviderFactory";
    }

    public String getDisplayName() {
        return this.name();
    }

    public FileProvider createFileProvider() {
        return new FileProviderImpl();
    }

    private static final class OtherFD
    extends FDImpl {
        private final String name;
        private final Folder folder;
        private final String baseDir;

        public OtherFD(String name, Project project, String baseDir, Folder folder) {
            super(name, project);
            this.name = name;
            this.folder = folder;
            this.baseDir = baseDir;
        }

        public String getOwnerPath() {
            return this.folder.getPath();
        }

        @Override
        protected DataObject getDataObject() {
            try {
                FileObject fo = this.getFileObject();
                if (fo != null && fo.isValid()) {
                    return DataObject.find((FileObject)fo);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return null;
        }

        public FileObject getFileObject() {
            FileObject fileObject = RemoteFileUtil.getFileObject((FileObject)this.folder.getConfigurationDescriptor().getBaseDirFileObject(), (String)(this.folder.getRootPath() + "/" + this.name));
            if (fileObject != null && fileObject.isValid()) {
                return fileObject;
            }
            return null;
        }

        public String getFileDisplayPath() {
            return this.folder.getRootPath() + "/" + this.name;
        }
    }

    private static final class ItemFD
    extends FDImpl {
        private static final boolean VISUALIZE_LINK = true;
        private final ItemEx item;

        public ItemFD(ItemEx item, Project project) {
            super(item.getName(), project);
            this.item = item;
        }

        public String getOwnerPath() {
            String path;
            StringBuilder out = new StringBuilder();
            for (Folder parent = this.item.getFolder(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
                if (out.length() > 0) {
                    out.insert(0, "/");
                }
                out.insert(0, parent.getDisplayName());
            }
            String canPath = this.item.getCanonicalPath();
            if (!canPath.equals(path = this.item.getAbsolutePath())) {
                return "\u2191" + out.toString();
            }
            return out.toString();
        }

        public FileObject getFileObject() {
            return this.item.getFileObject();
        }

        @Override
        protected DataObject getDataObject() {
            return this.item.getDataObject();
        }

        public String getFileDisplayPath() {
            return this.item.getNormalizedPath();
        }
    }

    private static abstract class FDImpl
    extends FileDescriptor {
        private final String fileName;
        private final Project project;

        public FDImpl(String fileName, Project project) {
            this.fileName = fileName;
            this.project = project;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final String getProjectName() {
            ProjectInformation info = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
            return info.getDisplayName();
        }

        public final Icon getProjectIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/resources/makeProject.gif", (boolean)true);
        }

        public final void open() {
            DataObject od = this.getDataObject();
            if (od != null) {
                Editable ec = (Editable)od.getLookup().lookup(Editable.class);
                if (ec != null) {
                    ec.edit();
                } else {
                    Openable oc = (Openable)od.getLookup().lookup(Openable.class);
                    if (oc != null) {
                        oc.open();
                    }
                }
            }
        }

        public final Icon getIcon() {
            DataObject od = this.getDataObject();
            if (od != null) {
                Image i = od.getNodeDelegate().getIcon(1);
                return new ImageIcon(i);
            }
            return null;
        }

        protected abstract DataObject getDataObject();
    }

    public static final class FileProviderImpl
    extends MakeProjectFileProvider.NativeFileSearchImpl
    implements FileProvider {
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final Set<SearchContext> searchedProjects = new HashSet<SearchContext>();
        private FileProvider.Context lastContext = null;

        public boolean computeFiles(FileProvider.Context context, FileProvider.Result result) {
            this.cancel.set(false);
            Project project = context.getProject();
            if (project == null) {
                LOG.log(Level.FINE, "ComputeFiles: no project for {0}", context.getRoot());
                return false;
            }
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider == null) {
                LOG.log(Level.FINE, "ComputeFiles: no make project for {0}", context.getRoot());
                return false;
            }
            SearchContext searchContext = new SearchContext(context.getText(), context.getSearchType(), project);
            if (context != this.lastContext) {
                this.lastContext = context;
                this.searchedProjects.clear();
            }
            if (this.searchedProjects.add(searchContext)) {
                if (provider.gotDescriptor()) {
                    MakeConfigurationDescriptor descriptor = provider.getConfigurationDescriptor();
                    Sources srcs = ProjectUtils.getSources((Project)project);
                    SourceGroup[] genericSG = srcs.getSourceGroups("generic");
                    if (genericSG != null && genericSG.length > 0) {
                        for (SourceGroup group : genericSG) {
                            if (!group.getRootFolder().equals(context.getRoot())) continue;
                            NameMatcher matcher = NameMatcherFactory.createNameMatcher((String)context.getText(), (SearchType)context.getSearchType());
                            this.computeFiles(project, descriptor, matcher, result);
                        }
                    }
                } else {
                    LOG.log(Level.FINE, "ComputeFiles: skip search because project is not ready yet {0}", searchContext);
                }
            } else {
                LOG.log(Level.FINE, "ComputeFiles: skip already searched context {0}", searchContext);
            }
            return true;
        }

        private Collection<FSPath> defaultSearch(NativeProject project, String fileName, ExecutionEnvironment env) {
            Collection res;
            block5: {
                UserOptionsProvider userOptionsProvider;
                NativeFileSearch search;
                res = null;
                if (env == null) {
                    env = ExecutionEnvironmentFactory.getLocal();
                }
                boolean isDoSearch = false;
                if (env.isLocal()) {
                    isDoSearch = true;
                } else if (Boolean.valueOf(System.getProperty("cnd.pkg.search.enabled", "true")).booleanValue()) {
                    isDoSearch = ConnectionManager.getInstance().isConnectedTo(env);
                }
                if (packageSearch.isEmpty() || !isDoSearch) break block5;
                Iterator iterator = packageSearch.iterator();
                while (iterator.hasNext() && ((search = (userOptionsProvider = (UserOptionsProvider)iterator.next()).getPackageFileSearch(env)) == null || (res = search.searchFile(project, fileName)) == null)) {
                }
            }
            return res;
        }

        public void cancel() {
            this.cancel.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeFiles(Project project, MakeConfigurationDescriptor descriptor, NameMatcher matcher, FileProvider.Result result) {
            FileObject projectDirectoryFO = project.getProjectDirectory();
            if (projectDirectoryFO != null) {
                Item[] nbFO = projectDirectoryFO.getFileObject("nbproject");
                this.computeFOs((FileObject)nbFO, matcher, result);
            }
            for (FileObject fileObject : descriptor.getExternalFileItemsAsArray()) {
                if (this.cancel.get()) {
                    return;
                }
                if (!matcher.accept(fileObject.getName())) continue;
                result.addFileDescriptor((FileDescriptor)new ItemFD((ItemEx)fileObject, project));
            }
            for (Item item : descriptor.getProjectItems()) {
                if (this.cancel.get()) {
                    return;
                }
                if (!matcher.accept(item.getName())) continue;
                result.addFileDescriptor((FileDescriptor)new ItemFD((ItemEx)item, project));
            }
            HashMap projectSearchBase = (HashMap)searchBase.get(project);
            if (projectSearchBase != null) {
                HashMap hashMap = projectSearchBase;
                synchronized (hashMap) {
                    projectSearchBase = new HashMap(projectSearchBase);
                }
                String baseDir = descriptor.getBaseDir();
                for (Map.Entry entry : projectSearchBase.entrySet()) {
                    if (this.cancel.get()) {
                        return;
                    }
                    Folder folder = (Folder)entry.getKey();
                    List files = (List)entry.getValue();
                    if (files == null) continue;
                    List list = files;
                    synchronized (list) {
                        for (CharSequence name : files) {
                            if (this.cancel.get()) {
                                return;
                            }
                            if (!matcher.accept(name.toString())) continue;
                            result.addFileDescriptor((FileDescriptor)new OtherFD(name.toString(), project, baseDir, folder));
                        }
                    }
                }
            }
        }

        private void computeFOs(FileObject nbFO, NameMatcher matcher, FileProvider.Result result) {
            if (nbFO != null) {
                assert (nbFO.isFolder());
                for (FileObject fileObject : nbFO.getChildren()) {
                    if (fileObject.isFolder()) {
                        this.computeFOs(fileObject, matcher, result);
                        continue;
                    }
                    if (!matcher.accept(fileObject.getNameExt())) continue;
                    result.addFile(fileObject);
                }
            }
        }

        private static final class SearchContext {
            private final String searchText;
            private final SearchType searchType;
            private final Project project;

            public SearchContext(String searchText, SearchType searchType, Project project) {
                this.searchText = searchText;
                this.searchType = searchType;
                this.project = project;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SearchContext other = (SearchContext)obj;
                if (this.searchText == null ? other.searchText != null : !this.searchText.equals(other.searchText)) {
                    return false;
                }
                if (this.searchType != other.searchType) {
                    return false;
                }
                return this.project == other.project || this.project != null && this.project.equals(other.project);
            }

            public int hashCode() {
                int hash = 7;
                hash = 43 * hash + (this.searchText != null ? this.searchText.hashCode() : 0);
                hash = 43 * hash + (this.searchType != null ? this.searchType.hashCode() : 0);
                hash = 43 * hash + (this.project != null ? this.project.hashCode() : 0);
                return hash;
            }

            public String toString() {
                return "SearchContext{searchText=" + this.searchText + ", searchType=" + this.searchType + ", project=" + this.project + '}';
            }
        }
    }
}

