/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.RemoteJavaExecution;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.source.SourceFile;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public abstract class BaseDwarfProvider
extends BaseProvider {
    protected final ProviderProperty<FileSystem> BYNARY_FILESYSTEM_PROPERTY;
    private Map<String, GrepEntry> grepBase = new ConcurrentHashMap<String, GrepEntry>();

    public BaseDwarfProvider() {
        this.BYNARY_FILESYSTEM_PROPERTY = new ProviderProperty<FileSystem>(){
            private FileSystem fs;

            public String getName() {
                return "";
            }

            public String getDescription() {
                return "";
            }

            public FileSystem getValue() {
                return this.fs;
            }

            public void setValue(FileSystem value) {
                this.fs = value;
            }

            public ProviderPropertyType<FileSystem> getPropertyType() {
                return ProviderPropertyType.BinaryFileSystemPropertyType;
            }
        };
    }

    @Override
    protected void after() {
        this.grepBase.clear();
        this.grepBase = new ConcurrentHashMap<String, GrepEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicableImpl sizeComilationUnit(ProjectProxy project, Collection<String> objFileNames, Set<String> dlls, boolean findMain) {
        int res = 0;
        int sunStudio = 0;
        Dwarf dump = null;
        MyPosition position = null;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> searchPaths = new ArrayList<String>();
        TreeMap<String, AtomicInteger> realRoots = new TreeMap<String, AtomicInteger>();
        TreeMap<String, AtomicInteger> roots = new TreeMap<String, AtomicInteger>();
        int foundDebug = 0;
        HashMap<String, AtomicInteger> compilers = new HashMap<String, AtomicInteger>();
        for (String objFileName : objFileNames) {
            try {
                Object lang;
                dump = new Dwarf(objFileName);
                Dwarf.CompilationUnitIterator iterator = dump.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    String compilerName;
                    String resolvedLink;
                    ItemProperties.LanguageKind language;
                    CompilationUnitInterface cu = iterator.next();
                    if (cu == null || cu.getSourceFileName() == null || (lang = cu.getSourceLanguage()) == null) continue;
                    ++foundDebug;
                    Object path = cu.getSourceFileAbsolutePath();
                    path = this.getCommpilerSettings().getNormalizedPath((String)path);
                    if (!CndFileUtils.isExistingFile((String)path)) {
                        String fileFinder = Dwarf.fileFinder((String)objFileName, (String)path);
                        if (fileFinder == null || !CndFileUtils.isExistingFile((String)(fileFinder = this.getCommpilerSettings().getNormalizedPath(fileFinder)))) continue;
                        path = fileFinder;
                    }
                    if (LANG.DW_LANG_C.toString().equals(lang) || LANG.DW_LANG_C89.toString().equals(lang) || LANG.DW_LANG_C99.toString().equals(lang)) {
                        language = ItemProperties.LanguageKind.C;
                        ++res;
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
                        language = ItemProperties.LanguageKind.CPP;
                        ++res;
                    } else {
                        if (!LANG.DW_LANG_Fortran77.toString().equals(lang) && !LANG.DW_LANG_Fortran90.toString().equals(lang) && !LANG.DW_LANG_Fortran95.toString().equals(lang)) continue;
                        language = ItemProperties.LanguageKind.Fortran;
                        ++res;
                    }
                    this.incrementRoot((String)path, roots);
                    if (project.resolveSymbolicLinks() && (resolvedLink = DiscoveryUtils.resolveSymbolicLink((FileSystem)this.getSourceFileSystem(), (String)path)) != null) {
                        this.incrementRoot(resolvedLink, roots);
                    }
                    if ((compilerName = DwarfSource.extractCompilerName(cu, language)) != null) {
                        AtomicInteger count = (AtomicInteger)compilers.get(compilerName);
                        if (count == null) {
                            count = new AtomicInteger();
                            compilers.put(compilerName, count);
                        }
                        count.incrementAndGet();
                    }
                    if (DwarfSource.isSunStudioCompiler(cu)) {
                        ++sunStudio;
                    }
                    if (!findMain || position != null || !cu.hasMain()) continue;
                    int line = cu.getMainLine();
                    if (line > 0) {
                        position = new MyPosition((String)path, line);
                        continue;
                    }
                    position = new MyPosition((String)path, 1);
                }
                if (dlls == null) continue;
                ElfReader.SharedLibraries pubNames = dump.readPubNames();
                lang = dlls;
                synchronized (lang) {
                    for (String dll : pubNames.getDlls()) {
                        if (dlls.contains(dll)) continue;
                        dlls.add(dll);
                    }
                    for (String s : pubNames.getPaths()) {
                        if (searchPaths.contains(s)) continue;
                        searchPaths.add(s);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"FileNotFoundException", (Object)objFileName));
                if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                DwarfSource.LOG.log(Level.FINE, "File not found {0}: {1}", new Object[]{objFileName, ex.getMessage()});
            }
            catch (WrongFileFormatException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"WrongFileFormatException", (Object)objFileName));
                if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                DwarfSource.LOG.log(Level.FINE, "Unsuported format of file {0}: {1}", new Object[]{objFileName, ex.getMessage()});
            }
            catch (IOException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"IOException", (Object)objFileName, (Object)ex.toString()));
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            catch (Throwable ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"Exception", (Object)objFileName, (Object)ex.toString()));
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            finally {
                if (dump == null) continue;
                dump.dispose();
            }
        }
        int max = 0;
        String top = "";
        for (Map.Entry entry : compilers.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= max) continue;
            max = ((AtomicInteger)entry.getValue()).get();
            top = (String)entry.getKey();
        }
        ArrayList<String> dllResult = null;
        if (dlls != null) {
            dllResult = new ArrayList<String>(dlls);
        }
        ArrayList pathsResult = null;
        if (dlls != null) {
            pathsResult = new ArrayList(searchPaths);
        }
        String commonRoot = this.getRoot(roots);
        if (res > 0) {
            return new ApplicableImpl(true, errors, top, res, sunStudio > res / 2, dllResult, pathsResult, commonRoot, position);
        }
        if (errors.isEmpty()) {
            if (foundDebug > 0) {
                String notFoundRoot = this.getRoot(realRoots);
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"BadDebugInformation", (Object)notFoundRoot));
            } else {
                StringBuilder buf = new StringBuilder();
                for (String s : objFileNames) {
                    if (buf.length() > 0) {
                        buf.append(';');
                    }
                    buf.append(s);
                }
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"NotFoundDebugInformation", (Object)buf.toString()));
            }
        }
        return new ApplicableImpl(false, errors, top, res, sunStudio > res / 2, dllResult, pathsResult, commonRoot, position);
    }

    private void incrementRoot(String path, Map<String, AtomicInteger> roots) {
        int i = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (i >= 0) {
            String folder = path.substring(0, i);
            AtomicInteger val = roots.get(folder);
            if (val == null) {
                val = new AtomicInteger();
                roots.put(folder, val);
            }
            val.incrementAndGet();
        }
    }

    private String getCommonPart(String path, String commonRoot) {
        String[] splitPath = path.split("/");
        ArrayList<String> list1 = new ArrayList<String>();
        boolean isUnixPath = false;
        for (int i = 0; i < splitPath.length; ++i) {
            if (!splitPath[i].isEmpty()) {
                list1.add(splitPath[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixPath = true;
        }
        String[] splitRoot = commonRoot.split("/");
        ArrayList<String> list2 = new ArrayList<String>();
        boolean isUnixRoot = false;
        for (int i = 0; i < splitRoot.length; ++i) {
            if (!splitRoot[i].isEmpty()) {
                list2.add(splitRoot[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixRoot = true;
        }
        if (isUnixPath != isUnixRoot) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (isUnixPath) {
            buf.append('/');
        }
        for (int i = 0; i < Math.min(list1.size(), list2.size()) && ((String)list1.get(i)).equals(list2.get(i)); ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append((String)list1.get(i));
        }
        return buf.toString();
    }

    private String getRoot(TreeMap<String, AtomicInteger> roots) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<AtomicInteger> resCount = new ArrayList<AtomicInteger>();
        String current = null;
        AtomicInteger currentCount = null;
        for (Map.Entry<String, AtomicInteger> entry : roots.entrySet()) {
            int length;
            if (current == null) {
                current = entry.getKey();
                currentCount = new AtomicInteger(entry.getValue().get());
                continue;
            }
            String s = this.getCommonPart(entry.getKey(), current);
            String[] split = s.split("/");
            int n = length = split.length > 0 && split[0].isEmpty() ? split.length - 1 : split.length;
            if (length >= 2) {
                current = s;
                currentCount.addAndGet(entry.getValue().get());
                continue;
            }
            res.add(current);
            resCount.add(currentCount);
            current = entry.getKey();
            currentCount = new AtomicInteger(entry.getValue().get());
        }
        if (current != null) {
            res.add(current);
            resCount.add(currentCount);
        }
        TreeMap newRoots = new TreeMap();
        String bestRoot = null;
        int bestCount = 0;
        for (int i = 0; i < res.size(); ++i) {
            newRoots.put(res.get(i), resCount.get(i));
            if (bestRoot == null) {
                bestRoot = (String)res.get(i);
                bestCount = ((AtomicInteger)resCount.get(i)).get();
                continue;
            }
            if (bestCount >= ((AtomicInteger)resCount.get(i)).get()) continue;
            bestRoot = (String)res.get(i);
            bestCount = ((AtomicInteger)resCount.get(i)).get();
        }
        return bestRoot;
    }

    @Override
    protected List<SourceFileProperties> getSourceFileProperties(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, Map<ItemProperties.LanguageKind, Map<String, Integer>> buildTools, CompileLineStorage storage) {
        FileSystem fs = (FileSystem)this.BYNARY_FILESYSTEM_PROPERTY.getValue();
        if (fs == null || CndFileUtils.isLocalFileSystem((FileSystem)fs)) {
            return this.getSourceFilePropertiesLocal(objFileName, map, project, dlls, buildArtifacts, buildTools, storage);
        }
        return this.getSourceFilePropertiesRemote(objFileName, map, project, dlls, buildArtifacts, buildTools, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SourceFileProperties> getSourceFilePropertiesRemote(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, Map<ItemProperties.LanguageKind, Map<String, Integer>> buildTools, CompileLineStorage storage) {
        ArrayList<SourceFileProperties> list;
        block8: {
            list = new ArrayList<SourceFileProperties>();
            FileSystem fs = (FileSystem)this.BYNARY_FILESYSTEM_PROPERTY.getValue();
            ExecutionEnvironment ee = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
            if (ConnectionManager.getInstance().isConnectedTo(ee)) {
                RemoteJavaExecution processor = new RemoteJavaExecution(fs);
                try {
                    for (SourceFile cu : processor.getCompileLines(objFileName, true)) {
                        if (this.getStopInterrupter().cancelled()) break;
                        this.processUnit((CompilationUnitInterface)cu, objFileName, storage, map, project, list);
                    }
                    if (dlls == null) break block8;
                    ElfReader.SharedLibraries pubNames = processor.getDlls(objFileName);
                    Set<String> set = dlls;
                    synchronized (set) {
                        for (String dll : pubNames.getDlls()) {
                            dlls.add(dll);
                        }
                    }
                }
                catch (IOException ex) {
                    DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SourceFileProperties> getSourceFilePropertiesLocal(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, Map<ItemProperties.LanguageKind, Map<String, Integer>> buildTools, CompileLineStorage storage) {
        ArrayList<SourceFileProperties> list;
        block20: {
            list = new ArrayList<SourceFileProperties>();
            Dwarf dump = null;
            try {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Process file {0}", objFileName);
                }
                dump = new Dwarf(objFileName);
                Dwarf.CompilationUnitIterator iterator = dump.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    CompilationUnitInterface cu = iterator.next();
                    if (cu == null) continue;
                    if (this.getStopInterrupter().cancelled()) break;
                    this.processUnit(cu, objFileName, storage, map, project, list);
                }
                if (dlls == null) break block20;
                ElfReader.SharedLibraries pubNames = dump.readPubNames();
                Set<String> set = dlls;
                synchronized (set) {
                    for (String dll : pubNames.getDlls()) {
                        dlls.add(dll);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "File not found {0}: {1}", new Object[]{objFileName, ex.getMessage()});
                }
            }
            catch (WrongFileFormatException ex) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Unsuported format of file {0}: {1}", new Object[]{objFileName, ex.getMessage()});
                }
            }
            catch (IOException ex) {
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            catch (Throwable ex) {
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            finally {
                if (dump != null) {
                    dump.dispose();
                }
            }
        }
        return list;
    }

    private void processUnit(CompilationUnitInterface cu, String objFileName, CompileLineStorage storage, Map<String, SourceFileProperties> map, ProjectProxy project, List<SourceFileProperties> list) throws IOException {
        if (cu.getSourceFileName() == null) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, "Compilation unit has broken name in file {0}", objFileName);
            }
            return;
        }
        String lang = cu.getSourceLanguage();
        if (lang == null) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, "Compilation unit has unresolved language in file {0}for {1}", new Object[]{objFileName, cu.getSourceFileName()});
            }
            return;
        }
        DwarfSource source = null;
        if (LANG.DW_LANG_C.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (LANG.DW_LANG_C89.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C89, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (LANG.DW_LANG_C99.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C99, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.CPP, ItemProperties.LanguageStandard.Unknown, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (LANG.DW_LANG_Fortran77.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F77, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (LANG.DW_LANG_Fortran90.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F90, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (LANG.DW_LANG_Fortran95.toString().equals(lang)) {
            source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F95, this.getCommpilerSettings(), this.grepBase, storage);
        } else if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "Unknown language: {0}", lang);
        }
        if (source != null) {
            String resolvedLink;
            if (source.getCompilePath() == null) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Compilation unit has NULL compile path in file {0}", objFileName);
                }
                return;
            }
            String name = source.getItemPath();
            source.process(cu);
            if (project.resolveSymbolicLinks() && (resolvedLink = DiscoveryUtils.resolveSymbolicLink((FileSystem)this.getSourceFileSystem(), (String)name)) != null) {
                DwarfSource original = DwarfSource.relocateDerivedSourceFile(source, resolvedLink);
                list.add(original);
                return;
            }
            list.add(source);
        }
    }

    private static final class MyPosition
    implements DiscoveryExtensionInterface.Position {
        private final String path;
        private final int line;

        private MyPosition(String path, int line) {
            this.path = path;
            this.line = line;
        }

        public String getFilePath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.path + ":" + this.line;
        }
    }

    public static final class GrepEntry {
        ArrayList<String> includes = new ArrayList();
        String firstMacro = null;
        int firstMacroLine = -1;
        boolean exists;
    }
}

