/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class DeleteLocalAction
extends ContextAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Delete";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return Mercurial.getInstance().getFileStatusCache().listFiles(context, 4100).length > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        final Set files = context.getRootFiles();
        for (VCSFileProxy f : files) {
            if ((cache.getCachedStatus(f).getStatus() & 0x1004) != 0) continue;
            return;
        }
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        descriptor.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        descriptor.setMessageType(2);
        descriptor.setOptionType(0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (res != NotifyDescriptor.YES_OPTION) {
            return;
        }
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                final Map<VCSFileProxy, Set<VCSFileProxy>> sortedFiles = HgUtils.sortUnderRepository(files);
                try {
                    HgUtils.runWithoutIndexing(new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            for (Map.Entry e : sortedFiles.entrySet()) {
                                try {
                                    HgCommand.doRevert((VCSFileProxy)e.getKey(), new ArrayList<VCSFileProxy>((Collection)e.getValue()), null, false, OutputLogger.getLogger(null));
                                }
                                catch (HgException ex) {
                                    Mercurial.LOG.log(Level.INFO, null, ex);
                                }
                                for (VCSFileProxy file : (Set)e.getValue()) {
                                    if (this.isCanceled()) {
                                        return null;
                                    }
                                    FileObject fo = file.toFileObject();
                                    if (fo == null) continue;
                                    FileLock lock = null;
                                    try {
                                        lock = fo.lock();
                                        fo.delete(lock);
                                    }
                                    catch (IOException ex) {
                                        Mercurial.LOG.log(Level.SEVERE, NbBundle.getMessage(DeleteLocalAction.class, (String)"MSG_Cannot_lock", (Object)file.getPath()), e);
                                    }
                                    finally {
                                        if (lock == null) continue;
                                        lock.releaseLock();
                                    }
                                }
                            }
                            return null;
                        }
                    }, files.toArray(new VCSFileProxy[files.size()]));
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        };
        support.start(Mercurial.getInstance().getRequestProcessor(), HgUtils.getRootFile(context), NbBundle.getMessage(DeleteLocalAction.class, (String)"LBL_DeleteLocalAction.progress"));
    }
}

