/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.remote.ui.diff.MultiDiffPanel;
import org.netbeans.modules.remotefs.versioning.util.common.FileTreeView;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class DiffFileTreeImpl
extends FileTreeView<DiffNode> {
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private final MultiDiffPanel master;

    public DiffFileTreeImpl(MultiDiffPanel master) {
        this.master = master;
        this.setupColumns();
    }

    private void setupColumns() {
        this.view.setPropertyColumns(new String[]{"status", columnLabels.get("status")[0], "location", columnLabels.get("location")[0]});
        this.view.setPropertyColumnDescription("status", columnLabels.get("status")[1]);
        this.view.setPropertyColumnDescription("location", columnLabels.get("location")[1]);
        this.view.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffFileTreeImpl.class, (String)"ACSN_DiffTable"));
        this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffFileTreeImpl.class, (String)"ACSD_DiffTable"));
        this.view.getOutline().setRenderDataProvider(this.createRenderProvider());
    }

    protected DiffNode convertToAcceptedNode(Node node) {
        return node instanceof DiffNode ? (DiffNode)node : null;
    }

    private RenderDataProvider createRenderProvider() {
        return new FileTreeView.AbstractRenderDataProvider(){

            protected String annotateName(DiffNode node, String originalLabel) {
                if (HgModuleConfig.getDefault(DiffFileTreeImpl.this.master.getRoot()).isExcludedFromCommit(node.getSetup().getBaseFile().getPath())) {
                    originalLabel = "<s>" + (originalLabel == null ? node.getName() : originalLabel) + "</s>";
                }
                return originalLabel;
            }
        };
    }

    protected void nodeSelected(DiffNode node) {
        this.master.nodeSelected(node);
    }

    protected JPopupMenu getPopup() {
        return this.master.getPopup();
    }

    protected void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = DiffFileTreeImpl.this.view.getWidth();
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 40 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 40 / 100);
            }
        });
    }

    static {
        ResourceBundle loc = NbBundle.getBundle(DiffFileTreeImpl.class);
        columnLabels.put("status", new String[]{loc.getString("CTL_DiffTable_Column_Status_Title"), loc.getString("CTL_DiffTable_Column_Status_Desc")});
        columnLabels.put("location", new String[]{loc.getString("CTL_DiffTable_Column_Location_Title"), loc.getString("CTL_DiffTable_Column_Location_Desc")});
    }
}

