/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.conifg.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.sendto.action.FutureAction;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.dlight.sendto.api.OutputMode;
import org.netbeans.modules.dlight.sendto.api.ScriptsRegistry;
import org.netbeans.modules.dlight.sendto.conifg.impl.DefaultConfigurationPanel;
import org.netbeans.modules.dlight.sendto.output.OutputConvertorFactory;
import org.netbeans.modules.dlight.sendto.spi.Handler;
import org.netbeans.modules.dlight.sendto.util.ScriptExecutor;
import org.netbeans.modules.dlight.sendto.util.Utils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class DefaultScriptHandler
extends Handler<DefaultConfigurationPanel> {
    public static final String VALIDATION_SCRIPT = "validation_script";
    public static final String VALIDATION_SCRIPT_EXECUTOR = "validation_script_executor";
    public static final String SCRIPT = "script";
    public static final String SCRIPT_EXECUTOR = "script_executor";
    public static final String OUTPUT_MODE = "output_type";
    private final Object cacheLock = new Object();
    private final Map<Integer, FutureAction> cachedActions = new HashMap<Integer, FutureAction>();
    private final Map<Integer, FileChangeListener> flisteners = new HashMap<Integer, FileChangeListener>();
    private final Map<Integer, Collection<? extends FileObject>> cachedFileObjects = new HashMap<Integer, Collection<? extends FileObject>>();

    public DefaultScriptHandler() {
        super("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureAction createActionFor(Lookup actionContext, final Configuration cfg) {
        FutureAction action;
        assert (SwingUtilities.isEventDispatchThread());
        final Collection fos = actionContext.lookupAll(FileObject.class);
        if (fos == null || fos.isEmpty()) {
            return null;
        }
        ExecutionEnvironment _env = null;
        for (FileObject fo : fos) {
            if (_env == null) {
                _env = Utils.getExecutionEnvironment(fo);
                continue;
            }
            if (_env.equals((Object)Utils.getExecutionEnvironment(fo))) continue;
            return null;
        }
        final ExecutionEnvironment env = _env;
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            return new FutureAction(NbBundle.getMessage(DefaultScriptHandler.class, (String)"DefaultConfigurationPanel.hostNotConnected", (Object)env.getDisplayName()));
        }
        final Integer cfgID = cfg.getID();
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedActions.containsKey(cfgID) && this.cachedFileObjects.get(cfgID).containsAll(fos) && fos.containsAll(this.cachedFileObjects.get(cfgID))) {
                return this.cachedActions.get(cfgID);
            }
            FileChangeAdapter cl = new FileChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileAttributeChanged(FileAttributeEvent fe) {
                    Object object = DefaultScriptHandler.this.cacheLock;
                    synchronized (object) {
                        if (DefaultScriptHandler.this.cachedActions.containsKey(cfgID)) {
                            DefaultScriptHandler.this.cachedActions.remove(cfgID);
                        }
                    }
                }
            };
            this.flisteners.put(cfgID, (FileChangeListener)cl);
            for (FileObject fo : fos) {
                fo.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)cl, (Object)fo));
            }
            this.cachedFileObjects.put(cfgID, fos);
            action = new FutureAction(new Callable<Action>(){

                @Override
                public Action call() throws Exception {
                    return DefaultScriptHandler.this.createAction(fos, cfg, env);
                }
            });
            this.cachedActions.put(cfgID, action);
        }
        return action;
    }

    private Action createAction(final Collection<? extends FileObject> fos, final Configuration cfg, final ExecutionEnvironment env) {
        final String script = cfg.get(SCRIPT).trim();
        if (script.isEmpty()) {
            return null;
        }
        String validationScript = cfg.get(VALIDATION_SCRIPT).trim();
        String validationScriptExecutor = Utils.substituteShell(cfg.get(VALIDATION_SCRIPT_EXECUTOR).trim(), env);
        final ArrayList<String> args = new ArrayList<String>();
        args.add(null);
        for (FileObject fileObject : fos) {
            args.add(fileObject.getPath());
        }
        if (!validationScript.isEmpty()) {
            String validationScriptFile = ScriptsRegistry.getScriptFile(cfg, env, validationScript);
            if (validationScriptFile == null) {
                return null;
            }
            args.set(0, validationScriptFile);
            ProcessUtils.ExitStatus exitStatus = ProcessUtils.execute((ExecutionEnvironment)env, (String)validationScriptExecutor, (String[])args.toArray(new String[args.size()]));
            if (!exitStatus.isOK()) {
                return null;
            }
        }
        return new AbstractAction(cfg.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                String scriptPath = ScriptsRegistry.getScriptFile(cfg, env, script);
                if (scriptPath == null) {
                    return;
                }
                args.set(0, scriptPath);
                String scriptExecutor = Utils.substituteShell(cfg.get(DefaultScriptHandler.SCRIPT_EXECUTOR).trim(), env);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(scriptExecutor);
                cmd.addAll(args);
                ScriptExecutor executor = new ScriptExecutor(env, cmd);
                executor.execute(cfg.getName(), OutputMode.parse(cfg.get(DefaultScriptHandler.OUTPUT_MODE)), new OutputConvertorFactory(fos));
                for (FileObject f : fos) {
                    f.refresh(true);
                }
            }
        };
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DefaultScriptHandler.class, (String)"DefaultScriptConfigurator.description.text");
    }

    @Override
    protected DefaultConfigurationPanel createConfigurationPanel() {
        return new DefaultConfigurationPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChanges(Configuration cfg) {
        if (cfg.isModified()) {
            ScriptsRegistry.invalidate(cfg);
            Object object = this.cacheLock;
            synchronized (object) {
                this.cachedActions.clear();
            }
        }
    }
}

