/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetManagerEvents;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.RequestProcessor;

public final class Configurations {
    private final PropertyChangeSupport pcs;
    private final List<Configuration> configurations = new ArrayList<Configuration>();
    private final ReadWriteLock configurationsLock = new ReentrantReadWriteLock();
    private final List<NamedRunnable> tasks = new ArrayList<NamedRunnable>();
    private static final RequestProcessor RP = new RequestProcessor("Configurations events", 1);

    public Configurations() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configurations init(Configuration[] confs, int defaultConf) {
        ArrayList<NamedRunnable> toRun = new ArrayList<NamedRunnable>();
        Configuration def = null;
        this.configurationsLock.writeLock().lock();
        try {
            this.configurations.clear();
            if (confs != null) {
                int current = 0;
                for (int i = 0; i < confs.length; ++i) {
                    if (confs[i] != null) {
                        this.configurations.add(confs[i]);
                        if (current == defaultConf) {
                            confs[i].setDefault(true);
                            def = confs[i];
                        } else {
                            confs[i].setDefault(false);
                        }
                        ++current;
                        continue;
                    }
                    new Exception("Configuration[" + i + "]==null").printStackTrace();
                }
                if (def != null) {
                    toRun.addAll(this.tasks);
                    this.tasks.clear();
                }
            }
        }
        finally {
            this.configurationsLock.writeLock().unlock();
        }
        toRun.forEach(task -> this.runOnProjectReadiness((NamedRunnable)task, false));
        return this;
    }

    public void runOnProjectReadiness(NamedRunnable task) {
        this.runOnProjectReadiness(task, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnProjectReadiness(NamedRunnable task, boolean postpone) {
        MakeConfiguration active = null;
        this.configurationsLock.writeLock().lock();
        try {
            active = (MakeConfiguration)this.getActive();
            if (active == null && postpone) {
                this.tasks.add(task);
            }
        }
        finally {
            this.configurationsLock.writeLock().unlock();
        }
        if (active != null) {
            DevelopmentHostConfiguration host = active.getDevelopmentHost();
            CompilerSetManagerEvents.get((ExecutionEnvironment)host.getExecutionEnvironment()).runProjectReadiness(task);
        }
    }

    public int size() {
        this.configurationsLock.readLock().lock();
        try {
            int n = this.configurations.size();
            return n;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    public Configuration[] toArray() {
        this.configurationsLock.readLock().lock();
        try {
            Configuration[] configurationArray = this.configurations.toArray(new Configuration[this.size()]);
            return configurationArray;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    public Collection<Configuration> getConfigurations() {
        LinkedHashSet<Configuration> collection = new LinkedHashSet<Configuration>();
        this.configurationsLock.readLock().lock();
        try {
            collection.addAll(this.configurations);
            LinkedHashSet<Configuration> linkedHashSet = collection;
            return linkedHashSet;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration[] getClonedConfs() {
        this.configurationsLock.readLock().lock();
        try {
            Configuration[] cs = new Configuration[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Configuration c = this.configurations.get(i);
                cs[i] = c.cloneConf();
            }
            Configuration[] configurationArray = cs;
            return configurationArray;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConfsAsDisplayNames() {
        this.configurationsLock.readLock().lock();
        try {
            String[] names = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Configuration configuration = this.configurations.get(i);
                names[i] = configuration.toString();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConfsAsNames() {
        this.configurationsLock.readLock().lock();
        try {
            String[] names = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Configuration configuration = this.configurations.get(i);
                names[i] = configuration.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
    }

    public Configuration getConf(int index) {
        this.configurationsLock.readLock().lock();
        try {
            if (this.checkValidIndex(index)) {
                Configuration configuration = this.configurations.get(index);
                return configuration;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfByDisplayName(String displayName) {
        Configuration ret = null;
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration c : this.configurations) {
                if (!c.getDisplayName().equals(displayName)) continue;
                ret = c;
                break;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf(String name) {
        Configuration ret = null;
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration c : this.configurations) {
                if (!c.getName().equals(name)) continue;
                ret = c;
                break;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Configuration def) {
        Configuration old;
        if (def == null) {
            return;
        }
        boolean fire = false;
        this.configurationsLock.readLock().lock();
        try {
            old = this.getActive();
            if (def == old) {
                return;
            }
            for (Configuration c : this.configurations) {
                c.setDefault(false);
                if (c != def) continue;
                def.setDefault(true);
                fire = true;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        if (fire) {
            this.fireChangedActiveConfiguration(old, def);
        }
    }

    public void setActive(String name) {
        this.setActive(this.getConf(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(int index) {
        Configuration def;
        Configuration old;
        if (index < 0) {
            return;
        }
        this.configurationsLock.readLock().lock();
        try {
            old = this.getActive();
            if (!this.checkValidIndex(index)) {
                return;
            }
            def = this.configurations.get(index);
            if (def != null) {
                this.configurations.forEach(c -> c.setDefault(false));
                def.setDefault(true);
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        this.fireChangedActiveConfiguration(old, def);
    }

    public void fireChangedActiveConfiguration(Configuration oldActive, Configuration newActive) {
        RP.post(() -> this.pcs.firePropertyChange("activeConfiguration", oldActive, newActive));
    }

    public void fireChangedConfigurations(Configuration[] oldConf, Configuration[] newConf) {
        RP.post(() -> this.pcs.firePropertyChange("configurations", oldConf, newConf));
    }

    public String getActiveDisplayName() {
        String defDisplayName = null;
        Configuration def = this.getActive();
        if (def != null) {
            defDisplayName = def.getDisplayName();
        }
        return defDisplayName;
    }

    @Deprecated
    public Configuration getDefault() {
        return this.getActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getActive() {
        this.configurationsLock.readLock().lock();
        try {
            for (Configuration c : this.configurations) {
                if (!c.isDefault()) continue;
                Configuration configuration = c;
                return configuration;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveAsIndex() {
        this.configurationsLock.readLock().lock();
        try {
            int index = -1;
            for (Configuration c : this.configurations) {
                ++index;
                if (!c.isDefault()) continue;
                int n = index;
                return n;
            }
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return -1;
    }

    private boolean checkValidIndex(int index) {
        if (index < 0 || index >= this.size()) {
            new ArrayIndexOutOfBoundsException(index).printStackTrace();
            return false;
        }
        return true;
    }

    public Configurations cloneConfs() {
        Configurations clone = new Configurations();
        this.configurationsLock.readLock().lock();
        try {
            clone.init(this.getClonedConfs(), this.getActiveAsIndex());
        }
        finally {
            this.configurationsLock.readLock().unlock();
        }
        return clone;
    }
}

