/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platform;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.platform.StdLibraries;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class LibraryItem
implements Cloneable {
    public static final int PROJECT_ITEM = 0;
    public static final int STD_LIB_ITEM = 1;
    public static final int LIB_ITEM = 2;
    public static final int LIB_FILE_ITEM = 3;
    public static final int OPTION_ITEM = 4;
    private int type;

    private LibraryItem() {
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDescription() {
        return "Should be overridden";
    }

    public void setValue(String value) {
    }

    public String getPath() {
        return null;
    }

    public String toString() {
        return "Should be overridden";
    }

    public abstract String getOption(MakeConfiguration var1);

    public boolean canEdit() {
        return false;
    }

    public LibraryItem clone() {
        return this;
    }

    public static class OptionItem
    extends LibraryItem
    implements Cloneable {
        private String libraryOption;

        public OptionItem(String libraryOption) {
            this.libraryOption = libraryOption;
            this.setType(4);
        }

        public String getLibraryOption() {
            return this.libraryOption;
        }

        public void setLibraryOption(String libraryOption) {
            this.libraryOption = libraryOption;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(LibraryItem.class, (String)"LibraryOptionTxt", (Object)this.getLibraryOption());
        }

        @Override
        public String toString() {
            return this.getLibraryOption();
        }

        @Override
        public void setValue(String value) {
            this.setLibraryOption(value);
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            return this.getLibraryOption();
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public OptionItem clone() {
            return new OptionItem(this.getLibraryOption());
        }
    }

    public static class LibFileItem
    extends LibraryItem
    implements Cloneable {
        private String path;

        public LibFileItem(String path) {
            this.path = path;
            this.setType(3);
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(LibraryItem.class, (String)"LibraryFileTxt", (Object)this.getPath());
        }

        @Override
        public String toString() {
            return this.getPath();
        }

        @Override
        public void setValue(String value) {
            this.setPath(value);
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            String lpath = this.getPath();
            if (conf != null) {
                CompilerSet cs = conf.getCompilerSet().getCompilerSet();
                lpath = CndPathUtilities.quoteIfNecessary((String)CppUtils.normalizeDriveLetter(cs, lpath));
            }
            return lpath;
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public LibFileItem clone() {
            return new LibFileItem(this.getPath());
        }
    }

    public static class LibItem
    extends LibraryItem
    implements Cloneable {
        private String libName;

        public LibItem(String libName) {
            this.libName = libName;
            this.setType(2);
        }

        public String getLibName() {
            return this.libName;
        }

        public void setLibName(String libName) {
            this.libName = libName;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(LibraryItem.class, (String)"LibraryTxt", (Object)this.getLibName());
        }

        @Override
        public String toString() {
            return this.getLibName();
        }

        @Override
        public void setValue(String value) {
            this.setLibName(value);
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            CompilerSet cs = conf.getCompilerSet().getCompilerSet();
            if (cs != null) {
                String lib = this.getLibName();
                lib = CndPathUtilities.quoteIfNecessary((String)CppUtils.normalizeDriveLetter(cs, lib));
                return cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getLibraryFlag() + lib;
            }
            return "";
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public LibItem clone() {
            return new LibItem(this.getLibName());
        }
    }

    public static class StdLibItem
    extends LibraryItem
    implements Cloneable {
        private final String name;
        private final String displayName;
        private final String[] libs;

        public StdLibItem(String name, String displayName, String[] libs) {
            this.name = name;
            this.displayName = displayName;
            this.libs = libs;
            this.setType(1);
        }

        public static StdLibItem getStandardItem(String id) {
            return StdLibraries.getStandardLibary(id);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String[] getLibs() {
            return this.libs;
        }

        @Override
        public String getDescription() {
            StringBuilder options = new StringBuilder();
            for (int i = 0; i < this.libs.length; ++i) {
                if (options.length() > 0) {
                    options.append(' ');
                }
                options.append(this.libs[i]);
            }
            return NbBundle.getMessage(LibraryItem.class, (String)"StandardLibraryTxt", (Object)this.getDisplayName(), (Object)options.toString());
        }

        @Override
        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            StringBuilder options = new StringBuilder();
            String flag = null;
            for (int i = 0; i < this.libs.length; ++i) {
                if (this.libs[i].charAt(0) != '-') {
                    CompilerSet cs;
                    if (flag == null && (cs = conf.getCompilerSet().getCompilerSet()) != null) {
                        flag = cs.getCompilerFlavor().getToolchainDescriptor().getLinker().getLibraryFlag();
                    }
                    if (flag == null) continue;
                    options.append(flag).append(this.libs[i]).append(" ");
                    continue;
                }
                options.append(this.libs[i]).append(" ");
            }
            return options.toString();
        }

        @Override
        public boolean canEdit() {
            return false;
        }

        @Override
        public StdLibItem clone() {
            StdLibItem clone = new StdLibItem(this.getName(), this.getDisplayName(), this.getLibs());
            return clone;
        }
    }

    public static class ProjectItem
    extends LibraryItem
    implements Cloneable {
        private MakeArtifact makeArtifact;
        private Project project;

        public ProjectItem(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
            this.setType(0);
        }

        public MakeArtifact getMakeArtifact() {
            return this.makeArtifact;
        }

        public void setMakeArtifact(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
        }

        public Project getProject(FSPath baseDir) {
            if (this.project == null) {
                String location = CndPathUtilities.toAbsolutePath((FileObject)baseDir.getFileObject(), (String)this.getMakeArtifact().getProjectLocation());
                try {
                    FileObject fo = RemoteFileUtil.getFileObject((FileObject)baseDir.getFileObject(), (String)location);
                    if (fo != null && fo.isValid()) {
                        fo = CndFileUtils.getCanonicalFileObject((FileObject)fo);
                    }
                    if (fo != null && fo.isValid()) {
                        this.project = ProjectManager.getDefault().findProject(fo);
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot find subproject in '" + location + "' " + e);
                }
            }
            return this.project;
        }

        @Override
        public String getDescription() {
            String ret = NbBundle.getMessage(LibraryItem.class, (String)"ProjectTxt", (Object)this.getMakeArtifact().getProjectLocation());
            if (this.getMakeArtifact().getOutput() != null && this.getMakeArtifact().getOutput().length() > 0) {
                ret = ret + " (" + this.getMakeArtifact().getOutput() + ")";
            }
            return ret;
        }

        @Override
        public String toString() {
            String ret = CndPathUtilities.getBaseName((String)this.getMakeArtifact().getProjectLocation());
            if (this.getMakeArtifact().getOutput() != null && this.getMakeArtifact().getOutput().length() > 0) {
                ret = ret + " (" + this.getMakeArtifact().getOutput() + ")";
            }
            return ret;
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public String getPath() {
            String libPath = this.getMakeArtifact().getOutput();
            if (!CndPathUtilities.isPathAbsolute((CharSequence)libPath)) {
                libPath = this.getMakeArtifact().getProjectLocation() + '/' + libPath;
            }
            return libPath;
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            String libSearchPath;
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            Platform platform = Platforms.getPlatform(conf.getDevelopmentHost().getBuildPlatform());
            IntConfiguration librariesRunTimeSearchPathKind = conf.getLinkerConfiguration().getLibrariesRunTimeSearchPathKind();
            String libPath = this.getPath();
            String libDir = CndPathUtilities.getDirName((String)libPath);
            String libName = CndPathUtilities.getBaseName((String)libPath);
            switch (librariesRunTimeSearchPathKind.getValue()) {
                case 1: {
                    libSearchPath = libDir;
                    break;
                }
                case 2: {
                    StringBuilder buf = new StringBuilder();
                    buf.append('$').append("$ORIGIN").append('/');
                    buf.append(CndPathUtilities.getRelativePath((String)CndPathUtilities.getDirName((String)conf.getAbsoluteOutputValue()), (String)conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir()));
                    buf.append('/');
                    buf.append(libDir);
                    libSearchPath = CndPathUtilities.normalizeSlashes((String)buf.toString());
                    break;
                }
                case 3: {
                    StringBuilder buf = new StringBuilder(conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir());
                    buf.append('/');
                    buf.append(libDir);
                    libSearchPath = CndPathUtilities.normalizeUnixPath((String)CndPathUtilities.normalizeSlashes((String)buf.toString()));
                    break;
                }
                default: {
                    libSearchPath = null;
                }
            }
            return platform.getLibraryLinkOption(libName, libDir, libPath, libSearchPath, compilerSet);
        }

        @Override
        public boolean canEdit() {
            return false;
        }

        @Override
        public ProjectItem clone() {
            ProjectItem clone = new ProjectItem(this.getMakeArtifact());
            return clone;
        }
    }
}

