/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java.jni.actions;

import javax.swing.text.Document;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.mixeddev.MixedDevUtils;
import org.netbeans.modules.cnd.mixeddev.Triple;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.cnd.mixeddev.java.jni.actions.AbstractJNIAction;
import org.netbeans.modules.cnd.mixeddev.java.model.jni.JNIClass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttachToJavaWithNativeDebuggerAction
extends AbstractJNIAction {
    public AttachToJavaWithNativeDebuggerAction(Lookup context) {
        super(context);
        this.putValue("Name", NbBundle.getMessage(MixedDevUtils.class, (String)"cnd.mixeddev.attach_to_java_with_native_debugger"));
    }

    @Override
    protected boolean isEnabledAtPosition(Document doc, int caret) {
        return false;
    }

    @Override
    protected boolean isEnabled(Triple<DataObject, Document, Integer> context) {
        Session[] sessions;
        if (context == null) {
            return false;
        }
        FileObject javaFile = ((DataObject)context.first).getPrimaryFile();
        Document doc = (Document)context.second;
        int caret = (Integer)context.third;
        JNIClass cls = JNISupport.getJNIClass(doc, caret);
        if (cls == null) {
            return false;
        }
        Project javaProject = FileOwnerQuery.getOwner((FileObject)javaFile);
        for (Session session : sessions = DebuggerManager.getDebuggerManager().getSessions()) {
            Project sessionProject = (Project)session.lookupFirst(null, Project.class);
            if (javaProject != sessionProject) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void actionPerformedImpl(Node[] activatedNodes) {
        Triple<DataObject, Document, Integer> context = this.extractContext(activatedNodes);
        if (context != null) {
            Session[] sessions;
            FileObject javaFile = ((DataObject)context.first).getPrimaryFile();
            Document doc = (Document)context.second;
            int caret = (Integer)context.third;
            JNIClass cls = JNISupport.getJNIClass(doc, caret);
            if (cls == null) {
                return;
            }
            Project javaProject = FileOwnerQuery.getOwner((FileObject)javaFile);
            for (Session session : sessions = DebuggerManager.getDebuggerManager().getSessions()) {
                Project sessionProject = (Project)session.lookupFirst(null, Project.class);
                if (javaProject != sessionProject) continue;
                Session nativeSession = MixedDevUtils.attachToJavaProcess(session.getName(), cls.getClassInfo().getQualified(), cls.getJNIMethods().get(0).getName().toString(), true);
                DebuggerManager.getDebuggerManager().setCurrentSession(session);
            }
        }
    }
}

