/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class MIMENames {
    public static final String HEADER_MIME_TYPE = "text/x-h";
    public static final String PREPROC_MIME_TYPE = "text/x-cpp+preprocessor";
    public static final String SOURCES_MIME_TYPE = "text/x-cnd+sourcefile";
    public static final String DOXYGEN_MIME_TYPE = "text/x-doxygen";
    public static final String STRING_DOUBLE_MIME_TYPE = "text/x-cpp-string-double";
    public static final String STRING_SINGLE_MIME_TYPE = "text/x-cpp-string-single";
    public static final String CPLUSPLUS_MIME_TYPE = "text/x-c++";
    public static final String C_MIME_TYPE = "text/x-c";
    public static final String FORTRAN_MIME_TYPE = "text/x-fortran";
    public static final String MAKEFILE_MIME_TYPE = "text/x-make";
    public static final String CMAKE_MIME_TYPE = "text/x-cmake";
    public static final String CMAKE_INCLUDE_MIME_TYPE = "text/x-cmake-include";
    public static final String QTPROJECT_MIME_TYPE = "text/x-qtproject";
    public static final String SHELL_MIME_TYPE = "text/sh";
    public static final String BAT_MIME_TYPE = "text/bat";
    public static final String VISU_MIME_TYPE = "text/x-visu";
    public static final String LEX_MIME_TYPE = "text/x-lex";
    public static final String YACC_MIME_TYPE = "text/x-yacc";
    public static final String ASM_MIME_TYPE = "text/x-asm";
    public static final String ELF_EXE_MIME_TYPE = "application/x-executable+elf";
    public static final String EXE_MIME_TYPE = "application/x-exe";
    public static final String ELF_CORE_MIME_TYPE = "application/x-core+elf";
    public static final String ELF_SHOBJ_MIME_TYPE = "application/x-shobj+elf";
    public static final String ELF_STOBJ_MIME_TYPE = "application/x-stobj+elf";
    public static final String ELF_OBJECT_MIME_TYPE = "application/x-object+elf";
    public static final String ELF_GENERIC_MIME_TYPE = "application/x-elf";
    static final String C_HEADER_MIME_TYPE = "text/x-c/text/x-h";
    public static final String QT_UI_MIME_TYPE = "text/qtui+xml";
    public static final String QT_RESOURCE_MIME_TYPE = "text/qtresource+xml";
    public static final String QT_TRANSLATION_MIME_TYPE = "text/qttranslation+xml";
    public static final Set<String> CND_TEXT_MIME_TYPES;
    public static final Set<String> CND_SOURCE_MIME_TYPES;
    public static final Set<String> CND_SCRIPT_MIME_TYPES;

    private MIMENames() {
    }

    public static boolean isCndMimeType(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return CND_SOURCE_MIME_TYPES.contains(mime) || CND_SCRIPT_MIME_TYPES.contains(mime) || CND_TEXT_MIME_TYPES.contains(mime);
    }

    public static boolean isCppOrC(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(CPLUSPLUS_MIME_TYPE) || mime.equals(C_MIME_TYPE);
    }

    public static boolean isCppOrCOrFortran(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(CPLUSPLUS_MIME_TYPE) || mime.equals(C_MIME_TYPE) || mime.equals(FORTRAN_MIME_TYPE);
    }

    public static boolean isHeader(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(HEADER_MIME_TYPE) || mime.equals(C_HEADER_MIME_TYPE);
    }

    public static boolean isHeaderOrCpp(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(CPLUSPLUS_MIME_TYPE) || mime.equals(HEADER_MIME_TYPE) || mime.equals(C_HEADER_MIME_TYPE);
    }

    public static boolean isHeaderOrCppOrC(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(CPLUSPLUS_MIME_TYPE) || mime.equals(C_MIME_TYPE) || mime.equals(HEADER_MIME_TYPE) || mime.equals(C_HEADER_MIME_TYPE);
    }

    public static boolean isFortranOrHeaderOrCppOrC(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(CPLUSPLUS_MIME_TYPE) || mime.equals(C_MIME_TYPE) || mime.equals(HEADER_MIME_TYPE) || mime.equals(C_HEADER_MIME_TYPE) || mime.equals(FORTRAN_MIME_TYPE);
    }

    public static boolean isBinary(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(EXE_MIME_TYPE) || mime.equals(ELF_EXE_MIME_TYPE) || mime.equals(ELF_CORE_MIME_TYPE) || mime.equals(ELF_SHOBJ_MIME_TYPE) || mime.equals(ELF_STOBJ_MIME_TYPE) || mime.equals(ELF_GENERIC_MIME_TYPE) || mime.equals(ELF_OBJECT_MIME_TYPE);
    }

    public static boolean isBinaryExecutable(String mime) {
        if (mime == null || mime.length() == 0) {
            return false;
        }
        return mime.equals(EXE_MIME_TYPE) || mime.equals(ELF_EXE_MIME_TYPE);
    }

    static {
        CND_SOURCE_MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(HEADER_MIME_TYPE, C_HEADER_MIME_TYPE, CPLUSPLUS_MIME_TYPE, C_MIME_TYPE, FORTRAN_MIME_TYPE, ASM_MIME_TYPE)));
        CND_SCRIPT_MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(MAKEFILE_MIME_TYPE, CMAKE_MIME_TYPE, CMAKE_INCLUDE_MIME_TYPE, QTPROJECT_MIME_TYPE, SHELL_MIME_TYPE, BAT_MIME_TYPE, VISU_MIME_TYPE, LEX_MIME_TYPE, YACC_MIME_TYPE, QT_UI_MIME_TYPE, QT_RESOURCE_MIME_TYPE, QT_TRANSLATION_MIME_TYPE)));
        CND_TEXT_MIME_TYPES = CND_SOURCE_MIME_TYPES;
    }
}

