/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain;

import java.nio.charset.Charset;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.APIAccessor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Utilities;

public class Tool {
    private final ExecutionEnvironment executionEnvironment;
    private final CompilerFlavor flavor;
    private final ToolKind kind;
    private String name;
    private final String displayName;
    private String path;
    private CompilerSet compilerSet;

    protected Tool(ExecutionEnvironment executionEnvironment, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        this.executionEnvironment = executionEnvironment;
        this.flavor = flavor;
        this.kind = kind;
        this.name = name;
        this.displayName = displayName;
        this.path = path;
    }

    public ToolchainManager.ToolDescriptor getDescriptor() {
        return null;
    }

    public Tool createCopy(CompilerFlavor flavor) {
        return new Tool(this.executionEnvironment, flavor, this.kind, this.name, this.displayName, this.path);
    }

    public final ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public final CompilerFlavor getFlavor() {
        return this.flavor;
    }

    public boolean isReady() {
        return true;
    }

    public void waitReady(boolean reset) {
    }

    public final ToolKind getKind() {
        return this.kind;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public String getIncludeFilePathPrefix() {
        throw new UnsupportedOperationException();
    }

    public final CompilerSet getCompilerSet() {
        return this.compilerSet;
    }

    public String toString() {
        String n = this.getName();
        if (Utilities.isWindows() && n.endsWith(".exe")) {
            return n.substring(0, n.length() - 4);
        }
        return n;
    }

    private void setPath(String p) {
        if (p != null) {
            this.path = p;
            this.name = CndPathUtilities.getBaseName((String)this.path);
            if (Utilities.isWindows() && this.name.endsWith(".exe")) {
                this.name = this.name.substring(0, this.name.length() - 4);
            }
        }
    }

    private void setCompilerSet(CompilerSet compilerSet) {
        this.compilerSet = compilerSet;
    }

    private static Tool createTool(ExecutionEnvironment executionEnvironment, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        return new Tool(executionEnvironment, flavor, kind, name, displayName, path);
    }

    static {
        APIAccessor.register(new APIAccessorImpl());
    }

    private static final class APIAccessorImpl
    extends APIAccessor {
        private APIAccessorImpl() {
        }

        @Override
        public Tool createTool(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
            return Tool.createTool(env, flavor, kind, name, displayName, path);
        }

        @Override
        public void setCompilerSet(Tool tool, CompilerSet cs) {
            tool.setCompilerSet(cs);
        }

        @Override
        public void setToolPath(Tool tool, String p) {
            tool.setPath(p);
        }

        @Override
        public void setCharset(Charset charset, CompilerSet cs) {
            ((CompilerSetImpl)cs).setEncoding(charset);
        }
    }
}

