/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.web.core.syntax.Bundle;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JspHyperlinkProvider
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(Document doc, final int offset) {
        if (!(doc instanceof BaseDocument)) {
            return false;
        }
        final BaseDocument bdoc = (BaseDocument)doc;
        final AtomicBoolean result = new AtomicBoolean();
        bdoc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    SyntaxElement syntaxElement;
                    JTextComponent target = Utilities.getFocusedComponent();
                    if (target == null || target.getDocument() != bdoc) {
                        return;
                    }
                    JspSyntaxSupport jspSup = JspSyntaxSupport.get((Document)bdoc);
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)bdoc);
                    TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                    if (tokenSequence == null) {
                        return;
                    }
                    tokenSequence.move(offset);
                    if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                        return;
                    }
                    Token token = tokenSequence.token();
                    if (token.id() == JspTokenId.ATTR_VALUE && (syntaxElement = jspSup.getElementChain(offset)) != null) {
                        if (syntaxElement.getCompletionContext() == 3) {
                            SyntaxElement.Directive sed = (SyntaxElement.Directive)syntaxElement;
                            if ("include".equals(sed.getName())) {
                                result.set(JspHyperlinkProvider.this.containsAttribute(tokenSequence, "file"));
                            } else if ("page".equals(sed.getName())) {
                                result.set(JspHyperlinkProvider.this.containsAttribute(tokenSequence, "errorPage"));
                            }
                            return;
                        }
                        if (syntaxElement.getCompletionContext() == 1) {
                            while (tokenSequence.movePrevious() && tokenSequence.token().id() != JspTokenId.TAG) {
                                if (tokenSequence.token().id() != JspTokenId.ATTRIBUTE) continue;
                                String attributeName = tokenSequence.token().text().toString();
                                String tagName = ((SyntaxElement.Tag)syntaxElement).getName();
                                if ("jsp:include".equals(tagName) && "page".equals(attributeName)) {
                                    result.set(true);
                                    return;
                                }
                                if ("jsp:forward".equals(tagName) && "page".equals(attributeName)) {
                                    result.set(true);
                                    return;
                                }
                                if (!"jsp:useBean".equals(tagName) || !"type".equals(attributeName) && !"class".equals(attributeName)) continue;
                                result.set(true);
                                return;
                            }
                        }
                    }
                    result.set(JspHyperlinkProvider.this.canBeTagFile(tokenSequence, jspSup));
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
        return result.get();
    }

    private boolean containsAttribute(TokenSequence<?> tokenSequence, String attributeName) {
        while (tokenSequence.movePrevious() && tokenSequence.token().id() != JspTokenId.TAG) {
            if (tokenSequence.token().id() != JspTokenId.ATTRIBUTE) continue;
            return tokenSequence.token().text().toString().equals(attributeName);
        }
        return false;
    }

    public int[] getHyperlinkSpan(final Document doc, final int offset) {
        final AtomicReference returnTaskRef = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                BaseDocument bdoc = (BaseDocument)doc;
                JTextComponent target = Utilities.getFocusedComponent();
                if (target == null || target.getDocument() != bdoc) {
                    return;
                }
                JspSyntaxSupport jspSup = JspSyntaxSupport.get((Document)bdoc);
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)bdoc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(offset);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return;
                }
                Token token = tokenSequence.token();
                if (JspHyperlinkProvider.this.canBeTagFile(tokenSequence, jspSup)) {
                    int start = token.offset(tokenHierarchy);
                    final int end = token.offset(tokenHierarchy) + token.length();
                    String text = token.text().toString().trim();
                    if (text.startsWith("<")) {
                        ++start;
                    }
                    final int fstart = start;
                    returnTaskRef.set(new Callable<int[]>(){

                        @Override
                        public int[] call() throws Exception {
                            return new int[]{fstart, end};
                        }
                    });
                } else if (token.length() > 2) {
                    final int from = token.offset(tokenHierarchy) + 1;
                    final int to = token.offset(tokenHierarchy) + token.length() - 1;
                    returnTaskRef.set(new Callable<int[]>(){

                        @Override
                        public int[] call() throws Exception {
                            return new int[]{from, to};
                        }
                    });
                }
            }
        });
        try {
            Callable returnTask = (Callable)returnTaskRef.get();
            return returnTask == null ? null : (int[])returnTask.call();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public void performClickAction(final Document doc, final int offset) {
        JTextComponent target = Utilities.getFocusedComponent();
        if (target == null || target.getDocument() != doc) {
            return;
        }
        AtomicReference outOfDocumentLockTaskRef = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                JspSyntaxSupport jspSup = JspSyntaxSupport.get(doc);
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(offset);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return;
                }
                Token token = tokenSequence.token();
                while (tokenSequence.token().id() != JspTokenId.TAG && !"jsp:useBean".equals(tokenSequence.token().text().toString()) && tokenSequence.movePrevious()) {
                }
                if (tokenSequence.index() != -1 && tokenSequence.token().id() == JspTokenId.TAG) {
                    final String className = token.text().toString().substring(1, token.length() - 1).trim();
                    ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)jspSup.getFileObject());
                    JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (Collection)Collections.EMPTY_LIST);
                    AtomicBoolean cancel = new AtomicBoolean();
                    Compute<TypeElement> compute = new Compute<TypeElement>(cancel, source, JavaSource.Phase.ELEMENTS_RESOLVED, new Worker<TypeElement>(){

                        @Override
                        public TypeElement process(CompilationInfo info) {
                            return info.getElements().getTypeElement(className);
                        }
                    });
                    ProgressUtils.runOffEventDispatchThread(compute, (String)NbBundle.getMessage(JspHyperlinkProvider.class, (String)"MSG_goto-source"), (AtomicBoolean)cancel, (boolean)false);
                    if (cancel.get()) {
                        return;
                    }
                    TypeElement typeElement = compute.result();
                    if (typeElement != null && !UiUtils.open((ClasspathInfo)cpInfo, (Element)typeElement)) {
                        JspHyperlinkProvider.this.gotoSourceFailed();
                    }
                }
                tokenSequence.move(offset);
                if (!tokenSequence.moveNext()) {
                    return;
                }
                FileObject fObj = JspHyperlinkProvider.this.getTagFile(tokenSequence, jspSup);
                if (fObj != null) {
                    JspHyperlinkProvider.this.openInEditor(fObj);
                } else {
                    int closingQuotePos;
                    String path = token.text().toString();
                    int openingQuotePos = path.indexOf(34);
                    if (openingQuotePos > -1 && (closingQuotePos = (path = path.substring(openingQuotePos + 1)).indexOf(34)) > -1) {
                        path = path.substring(0, closingQuotePos);
                        fObj = JspUtils.getFileObject(doc, path);
                    }
                    if (fObj != null) {
                        JspHyperlinkProvider.this.openInEditor(fObj);
                    } else {
                        String msg = NbBundle.getMessage(JspHyperlinkProvider.class, (String)"LBL_file_not_found", (Object)path);
                        StatusDisplayer.getDefault().setStatusText(msg);
                    }
                }
            }
        });
        Runnable outOfDocumentLockTask = (Runnable)outOfDocumentLockTaskRef.get();
        if (outOfDocumentLockTask != null) {
            outOfDocumentLockTask.run();
        }
    }

    private String getTagName(String tagwithprefix) {
        int index = tagwithprefix.indexOf(58);
        if (index > 0) {
            return tagwithprefix.substring(index + 1);
        }
        return tagwithprefix;
    }

    private void openInEditor(FileObject fObj) {
        if (fObj != null) {
            Node.Cookie cookie;
            DataObject dobj;
            try {
                dobj = DataObject.find((FileObject)fObj);
            }
            catch (DataObjectNotFoundException e) {
                Exceptions.printStackTrace((Throwable)e);
                return;
            }
            if (dobj != null && (cookie = (Node.Cookie)dobj.getLookup().lookup(EditCookie.class)) != null) {
                ((EditCookie)cookie).edit();
            }
        }
    }

    private boolean canBeTagFile(TokenSequence<?> tokenSequence, JspSyntaxSupport jspSup) {
        Token token = tokenSequence.token();
        if (token.id() == JspTokenId.TAG) {
            String image = token.text().toString().trim();
            if (image.startsWith("<")) {
                image = image.substring(1).trim();
            }
            if (!image.startsWith("jsp:") && image.indexOf(58) != -1) {
                return true;
            }
        }
        return false;
    }

    private FileObject getTagFile(TokenSequence<?> tokenSequence, JspSyntaxSupport jspSup) {
        Token token = tokenSequence.token();
        if (token.id() == JspTokenId.TAG) {
            TagFileInfo fileInfo;
            TagLibraryInfo libInfo;
            List l;
            String image = token.text().toString().trim();
            if (image.startsWith("<")) {
                image = image.substring(1).trim();
            }
            if (!image.startsWith("jsp:") && image.indexOf(58) != -1 && (l = jspSup.getTags(image)).size() == 1 && (libInfo = ((TagInfo)l.get(0)).getTagLibrary()) != null && (fileInfo = libInfo.getTagFile(this.getTagName(image))) != null) {
                return JspUtils.getFileObject((Document)jspSup.getDocument(), fileInfo.getPath());
            }
        }
        return null;
    }

    private void navigateToUserBeanDef(Document doc, JspSyntaxSupport jspSup, JTextComponent target, String bean) throws BadLocationException {
        String text = doc.getText(0, doc.getLength());
        int index = text.indexOf(bean);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (index > 0) {
            tokenSequence.move(index);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == JspTokenId.ATTR_VALUE) {
                while (!(token.id() == JspTokenId.ATTRIBUTE && (token.text().toString().equals("class") || token.text().toString().equals("type")) || token.id() == JspTokenId.SYMBOL && token.text().toString().equals("/>") || !tokenSequence.moveNext())) {
                    token = tokenSequence.token();
                }
                if (tokenSequence.index() != -1 && token.id() == JspTokenId.SYMBOL) {
                    while (!(token.id() == JspTokenId.ATTRIBUTE && (token.text().toString().equals("class") || token.text().toString().equals("type")) || token.id() != JspTokenId.SYMBOL && token.text().toString().equals("<") || !tokenSequence.movePrevious())) {
                        token = tokenSequence.token();
                    }
                }
                if (tokenSequence.index() != -1 && token.id() == JspTokenId.ATTRIBUTE) {
                    while (token.id() != JspTokenId.ATTR_VALUE && tokenSequence.moveNext()) {
                        token = tokenSequence.token();
                    }
                }
                if (tokenSequence.index() != -1 && token.id() == JspTokenId.ATTR_VALUE) {
                    target.setCaretPosition(token.offset(tokenHierarchy) + 1);
                    break;
                }
            }
            index = text.indexOf(bean, index + bean.length());
        }
    }

    private void gotoSourceFailed() {
        String msg = Bundle.MSG_source_not_found();
        StatusDisplayer.getDefault().setStatusText(msg);
        Toolkit.getDefaultToolkit().beep();
    }

    public static interface Worker<T> {
        public T process(CompilationInfo var1);
    }

    private static final class Compute<T>
    implements Runnable,
    Task<CompilationController> {
        private final AtomicBoolean cancel;
        private final JavaSource source;
        private final JavaSource.Phase phase;
        private final Worker<T> worker;
        private T result;

        public Compute(AtomicBoolean cancel, JavaSource source, JavaSource.Phase phase, Worker<T> worker) {
            this.cancel = cancel;
            this.source = source;
            this.phase = phase;
            this.worker = worker;
        }

        @Override
        public void run() {
            try {
                this.source.runUserActionTask((Task)this, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.result = null;
            }
        }

        public void run(CompilationController parameter) throws Exception {
            if (this.cancel.get()) {
                return;
            }
            parameter.toPhase(this.phase);
            if (this.cancel.get()) {
                return;
            }
            T t = this.worker.process((CompilationInfo)parameter);
            if (this.cancel.get()) {
                return;
            }
            this.result = t;
        }

        public T result() {
            return this.result;
        }
    }
}

