/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;

public class DenseMapIterator<KeyT, ValueT>
implements type.iterator<DenseMapIterator<KeyT, ValueT>, std_pair.pair<KeyT, ValueT>>,
Cloneable {
    private final DenseMapInfo<KeyT> keyInfoT;
    private std_pair.pair<KeyT, ValueT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    protected DenseMapIterator() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT, std_pair.pair<KeyT, ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT, std_pair.pair<KeyT, ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIterator<KeyT, ValueT> $assignMove(DenseMapIterator<KeyT, ValueT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIterator(DenseMapIterator<KeyT, ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public std_pair.pair<KeyT, ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pair<KeyT, ValueT>> star$ref() {
        return new type.ref<std_pair.pair<KeyT, ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIterator.this.Ptr;
            }

            public std_pair.pair<KeyT, ValueT> $deref() {
                return DenseMapIterator.this.Buckets[this.localPtr];
            }

            public std_pair.pair<KeyT, ValueT> $set(std_pair.pair<KeyT, ValueT> value) {
                std_pair.pair pair2 = value;
                ((DenseMapIterator)DenseMapIterator.this).Buckets[this.localPtr] = pair2;
                return pair2;
            }

            public type.ptr<std_pair.pair<KeyT, ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIterator.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pair<KeyT, ValueT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIterator<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIterator<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIterator<KeyT, ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIterator<KeyT, ValueT> $postInc() {
        DenseMapIterator<KeyT, ValueT> tmp = new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        ++this.Ptr;
        return tmp;
    }

    private void AdvancePastEmptyBuckets() {
        KeyT Empty = this.keyInfoT.getEmptyKey();
        KeyT Tombstone = this.keyInfoT.getTombstoneKey();
        while (Native.$noteq((int)this.Ptr, (int)this.End) && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public DenseMapIterator<KeyT, ValueT> clone() {
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIterator<KeyT, ValueT> const_clone() {
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIterator) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIterator)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIterator) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIterator)other).Ptr);
        }
        return true;
    }
}

