/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.endian;

import org.clank.support.Casts;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.llvm.support.llvm;
import org.llvm.support.sys.sys;

public class EndianGlobals {
    public static <value_type> value_type byte_swap(value_type value, llvm.support.endianness endian2) {
        if (endian2 != llvm.support.endianness.__native && sys.IsBigEndianHost != (endian2 == llvm.support.endianness.big)) {
            throw new UnsupportedOperationException("Use specialization from sys to swap " + (value == null ? null : value.getClass()));
        }
        return value;
    }

    public static <value_type> value_type read(char.ptr memory2, Class<value_type> Type2, llvm.support.endianness endian2, int alignment) {
        throw new UnsupportedOperationException("Use specialization to read " + Type2);
    }

    public static long read_uint64(char.ptr memory2, int fromPos, llvm.support.endianness endian2, int alignment) {
        long ret = 0L;
        try {
            ret = (long)Casts.$char((byte)memory2.$at(fromPos + 7)) << 54 | (long)Casts.$char((byte)memory2.$at(fromPos + 6)) << 48 | (long)Casts.$char((byte)memory2.$at(fromPos + 5)) << 40 | (long)Casts.$char((byte)memory2.$at(fromPos + 4)) << 32;
            ret |= (long)(Casts.$char((byte)memory2.$at(fromPos + 3)) << 24 | Casts.$char((byte)memory2.$at(fromPos + 2)) << 16 | Casts.$char((byte)memory2.$at(fromPos + 1)) << 8 | Casts.$char((byte)memory2.$at(fromPos + 0)));
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static int read_uint32(char.ptr memory2, int fromPos, llvm.support.endianness endian2, int alignment) {
        int ret = 0;
        try {
            ret = Casts.$char((byte)memory2.$at(fromPos + 3)) << 24 | Casts.$char((byte)memory2.$at(fromPos + 2)) << 16 | Casts.$char((byte)memory2.$at(fromPos + 1)) << 8 | Casts.$char((byte)memory2.$at(fromPos + 0));
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static char read_uint16(char.ptr memory2, int fromPos, llvm.support.endianness endian2, int alignment) {
        char ret = '\u0000';
        try {
            ret = (char)(Casts.$char((byte)memory2.$at(fromPos + 1)) << 8 | Casts.$char((byte)memory2.$at(fromPos + 0)));
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static byte read_uchar(char.ptr memory2, int fromPos, llvm.support.endianness endian2, int alignment) {
        byte ret = 0;
        try {
            ret = memory2.$at(fromPos + 0);
        }
        catch (IndexOutOfBoundsException e) {
            llvm.errs().$out("reading out of boundary " + memory2.toString() + "\n");
        }
        return ret;
    }

    public static <value_type> value_type readNext(char.ptr memory2, Class<value_type> Type2, llvm.support.endianness endian2, int alignment) {
        throw new UnsupportedOperationException("Use specialization to read " + Type2);
    }

    public static long readNext_uint64(char.ptr memory2, llvm.support.endianness endian2, int alignment) {
        long ret = EndianGlobals.read_uint64(memory2, 0, endian2, alignment);
        memory2.$inc(NativeType.sizeof((long)ret));
        return ret;
    }

    public static int readNext_uint32(char.ptr memory2, llvm.support.endianness endian2, int alignment) {
        int ret = EndianGlobals.read_uint32(memory2, 0, endian2, alignment);
        memory2.$inc(NativeType.sizeof((int)ret));
        return ret;
    }

    public static char readNext_uint16(char.ptr memory2, llvm.support.endianness endian2, int alignment) {
        char ret = EndianGlobals.read_uint16(memory2, 0, endian2, alignment);
        memory2.$inc(NativeType.sizeof((char)ret));
        return ret;
    }

    public static <value_type> void write(char.ptr memory2, value_type value, Class<value_type> Type2, llvm.support.endianness endian2, int alignment) {
        throw new UnsupportedOperationException("EmptyBody");
    }
}

