/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.VariablesModelFilter;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ArrayVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.BaseVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.NullVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ObjectVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ResourceVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ScalarTypeVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.StringVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.UndefinedVariableNode;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.spi.viewmodel.ModelEvent;

public abstract class AbstractModelNode {
    private static final String RESOURCE = "resource";
    private static final String OBJECT = "object";
    private static final String ARRAY = "array";
    private static final String STRING = "string";
    private static final String UNDEF = "uninitialized";
    private static final String NULL = "null";
    private List<AbstractVariableNode> myVars;
    private AbstractModelNode myParent;

    AbstractModelNode(AbstractModelNode parent, List<Property> properties) {
        this.myParent = parent;
        this.initVariables(properties);
    }

    public AbstractModelNode getParent() {
        return this.myParent;
    }

    public boolean hasType(Set<VariablesModelFilter.FilterType> set) {
        return this.isTypeApplied(set);
    }

    public static VariablesModel.AbstractVariableNode createVariable(Property property, AbstractModelNode parent) {
        String type;
        switch (type = property.getType()) {
            case "string": {
                return new StringVariableNode(property, parent);
            }
            case "array": {
                return new ArrayVariableNode(property, parent);
            }
            case "uninitialized": {
                return new UndefinedVariableNode(property, parent);
            }
            case "null": {
                return new NullVariableNode(property, parent);
            }
            case "object": {
                return new ObjectVariableNode(property, parent);
            }
            case "resource": {
                return new ResourceVariableNode(property, parent);
            }
            case "boolean": 
            case "bool": 
            case "integer": 
            case "int": 
            case "float": {
                return new ScalarTypeVariableNode(property, parent);
            }
        }
        return new BaseVariableNode(property, parent);
    }

    protected abstract boolean isTypeApplied(Set<VariablesModelFilter.FilterType> var1);

    protected List<AbstractVariableNode> getVariables() {
        return this.myVars;
    }

    protected void initVariables(List<Property> properties) {
        if (properties == null) {
            return;
        }
        this.myVars = new ArrayList<AbstractVariableNode>();
        for (Property property : properties) {
            VariablesModel.AbstractVariableNode var = AbstractModelNode.createVariable(property, this);
            this.myVars.add(var);
        }
    }

    protected void setVars(List<AbstractVariableNode> variables) {
        this.myVars = variables;
    }

    protected boolean addAbsentChildren(AbstractModelNode node) {
        boolean hasChanged = false;
        if (node.getVariables() != null && node.getVariables().size() > 0) {
            for (AbstractVariableNode newChild : node.getVariables()) {
                this.getVariables().add(newChild);
                hasChanged = true;
            }
        }
        return hasChanged;
    }

    protected boolean updateExistedChildren(VariablesModel variablesModel, AbstractModelNode node, Collection<ModelEvent> events) {
        boolean hasChanged = false;
        ArrayList<AbstractVariableNode> list = new ArrayList<AbstractVariableNode>(this.getVariables());
        int currentIndx = 0;
        for (AbstractVariableNode child : list) {
            Property property = child.getProperty();
            int newIndex = node.findChild(property);
            if (newIndex == -1) {
                this.getVariables().remove(currentIndx);
                hasChanged = true;
                continue;
            }
            AbstractVariableNode newChild = node.getVariables().get(newIndex);
            Property newProp = newChild.getProperty();
            if (property.getType().equals(newProp.getType())) {
                node.getVariables().remove(newIndex);
                child.collectUpdates(variablesModel, newChild, events);
            } else {
                this.getVariables().remove(currentIndx);
                this.getVariables().add(currentIndx, newChild);
                node.getVariables().remove(newIndex);
                hasChanged = true;
            }
            ++currentIndx;
        }
        return hasChanged;
    }

    protected boolean updatePage(AbstractVariableNode node) {
        Property property = node.getProperty();
        if (property.getPageSize() > 0 && property.getPage() > 0) {
            this.addAbsentChildren(node);
            return true;
        }
        return false;
    }

    protected int findChild(Property property) {
        int index = 0;
        for (AbstractVariableNode node : this.getVariables()) {
            String nodePropName;
            Property prop = node.getProperty();
            String string = nodePropName = prop != null ? prop.getName() : null;
            if (nodePropName != null && nodePropName.equals(property.getName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

