/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.FoldingParser;
import org.netbeans.modules.cnd.editor.parser.impl.FoldingParserImpl;
import org.openide.filesystems.FileObject;

public class FoldingParserService
implements FoldingParser {
    @Override
    public List<CppFoldRecord> parse(FileObject fo, char[] buf) {
        String mimeType = fo.getMIMEType();
        Language lang = null;
        if ("text/x-h".equals(mimeType)) {
            lang = CppTokenId.languageHeader();
        } else if ("text/x-c++".equals(mimeType)) {
            lang = CppTokenId.languageCpp();
        } else if ("text/x-c".equals(mimeType)) {
            lang = CppTokenId.languageC();
        } else if ("text/x-cpp+preprocessor".equals(mimeType)) {
            lang = CppTokenId.languagePreproc();
        }
        if (lang == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<CppTokenId> set = new HashSet<CppTokenId>();
        set.add(CppTokenId.WHITESPACE);
        set.add(CppTokenId.NEW_LINE);
        StringReader reader = new StringReader(new String(buf));
        TokenHierarchy th = TokenHierarchy.create((Reader)reader, (Language)lang, set, null);
        TokenSequence tokenSequence = th.tokenSequence(lang);
        List<CppFoldRecord> list = FoldingParserImpl.parse(fo, tokenSequence);
        return list;
    }
}

