/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;

class StackEntry {
    private int index;
    private CppTokenId kind;
    private CppTokenId importantKind;
    private LikeTo likeTo = LikeTo.unknown;
    private String text;
    private int indent;
    private int selfIndent;
    private int lambdaIndent = 0;
    private int lambdaParen = 0;

    StackEntry(ExtendedTokenSequence ts) {
        this.index = ts.index();
        this.kind = (CppTokenId)ts.token().id();
        this.text = ts.token().text().toString();
        switch (this.kind) {
            case IF: 
            case ELSE: 
            case TRY: 
            case CATCH: 
            case WHILE: 
            case FOR: 
            case DO: 
            case ASM: 
            case SWITCH: {
                this.importantKind = this.kind;
                break;
            }
            default: {
                this.initImportant(ts);
            }
        }
    }

    private void initImportant(ExtendedTokenSequence ts) {
        int i = ts.index();
        try {
            boolean prevID;
            int bracket = 0;
            int paren = 0;
            int brace = 0;
            int triangle = 0;
            boolean hasID = false;
            Token<CppTokenId> id = ts.lookPreviousImportant();
            boolean bl = prevID = id != null && id.id() == CppTokenId.IDENTIFIER;
            block50: while (true) {
                if (!ts.movePrevious()) {
                    return;
                }
                Token<CppTokenId> current = ts.token();
                switch ((CppTokenId)current.id()) {
                    case TEMPLATE: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        this.likeTo = LikeTo.function;
                        break;
                    }
                    case IDENTIFIER: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        hasID = true;
                        break;
                    }
                    case RPAREN: {
                        if (paren == 0 && triangle == 0 && brace == 0) {
                            this.likeTo = LikeTo.function;
                            Token<CppTokenId> next = ts.lookNextImportant();
                            if (next != null && next.id() == CppTokenId.COLON && prevID) {
                                this.likeTo = LikeTo.arrayInitialization;
                                return;
                            }
                        }
                        ++paren;
                        break;
                    }
                    case LPAREN: {
                        Token<CppTokenId> prev;
                        if (paren == 0) {
                            prev = ts.lookPreviousImportant();
                            if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                                this.likeTo = LikeTo.function;
                                return;
                            }
                            this.likeTo = LikeTo.arrayInitialization;
                            return;
                        }
                        --paren;
                        break;
                    }
                    case LBRACKET: {
                        if (paren != 0 || triangle != 0 || brace != 0 || --bracket != 0) continue block50;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null) {
                            if (prev.id() == CppTokenId.OPERATOR) {
                                this.likeTo = LikeTo.function;
                                return;
                            }
                            if (prev.id() == CppTokenId.IDENTIFIER) {
                                this.likeTo = LikeTo.arrayInitialization;
                                return;
                            }
                            if (prev.id() == CppTokenId.IDENTIFIER || prev.id() == CppTokenId.RBRACKET || prev.id() == CppTokenId.LBRACKET) continue block50;
                        }
                        this.likeTo = LikeTo.unknown;
                        this.importantKind = CppTokenId.ARROW;
                        this.lambdaIndent = this.lambdaIndent(ts);
                        return;
                    }
                    case RBRACKET: {
                        ++bracket;
                        break;
                    }
                    case CASE: 
                    case DEFAULT: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        this.likeTo = LikeTo.unknown;
                        return;
                    }
                    case RBRACE: {
                        if (paren == 0 && triangle == 0 && brace == 0) {
                            if (hasID && this.likeTo != LikeTo.function) {
                                this.likeTo = LikeTo.unifiedInitialization;
                            }
                            return;
                        }
                        ++brace;
                        break;
                    }
                    case RETURN: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        this.likeTo = LikeTo.unifiedInitialization;
                        return;
                    }
                    case LBRACE: {
                        if (paren == 0 && triangle == 0 && brace == 0) {
                            if (hasID && this.likeTo != LikeTo.function) {
                                this.likeTo = LikeTo.unifiedInitialization;
                            }
                            return;
                        }
                        --brace;
                        break;
                    }
                    case SEMICOLON: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        if (hasID && this.likeTo != LikeTo.function) {
                            this.likeTo = LikeTo.unifiedInitialization;
                        }
                        return;
                    }
                    case EQ: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                            this.likeTo = LikeTo.function;
                            return;
                        }
                        this.likeTo = LikeTo.arrayInitialization;
                        return;
                    }
                    case NEW: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        this.likeTo = LikeTo.arrayInitialization;
                        return;
                    }
                    case GT: {
                        if (paren != 0) break;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                            this.likeTo = LikeTo.function;
                            return;
                        }
                        ++triangle;
                        break;
                    }
                    case LT: {
                        Token<CppTokenId> prev;
                        if (paren != 0) break;
                        if (triangle == 0) {
                            prev = ts.lookPreviousImportant();
                            if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                                this.likeTo = LikeTo.function;
                                return;
                            }
                            return;
                        }
                        --triangle;
                        break;
                    }
                    case NAMESPACE: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        this.importantKind = (CppTokenId)current.id();
                        this.likeTo = LikeTo.unknown;
                        return;
                    }
                    case CLASS: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        Token<CppTokenId> isEnum = ts.lookPreviousImportant();
                        this.importantKind = isEnum != null && isEnum.id() == CppTokenId.ENUM ? (CppTokenId)isEnum.id() : (CppTokenId)current.id();
                        this.likeTo = LikeTo.unknown;
                        return;
                    }
                    case STRUCT: 
                    case ENUM: 
                    case UNION: {
                        if (paren != 0 || triangle != 0 || brace != 0 || this.likeTo == LikeTo.function) continue block50;
                        this.likeTo = LikeTo.unknown;
                        this.importantKind = (CppTokenId)current.id();
                        return;
                    }
                    case EXTERN: {
                        if (paren != 0 || triangle != 0 || brace != 0 || this.likeTo == LikeTo.function) continue block50;
                        this.likeTo = LikeTo.unknown;
                        this.importantKind = CppTokenId.NAMESPACE;
                        return;
                    }
                    case IF: 
                    case ELSE: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case SWITCH: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        this.importantKind = (CppTokenId)current.id();
                        this.likeTo = LikeTo.unknown;
                        return;
                    }
                    case ARROW: {
                        if (paren != 0 || triangle != 0 || brace != 0) continue block50;
                        Token<CppTokenId> prev = ts.lookPreviousImportant();
                        if (prev != null && prev.id() == CppTokenId.OPERATOR) {
                            this.likeTo = LikeTo.function;
                            return;
                        }
                        this.importantKind = (CppTokenId)current.id();
                        this.likeTo = LikeTo.unknown;
                        this.lambdaIndent = this.lambdaIndent(ts);
                        return;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(i);
            ts.moveNext();
        }
    }

    private int lambdaIndent(ExtendedTokenSequence ts) {
        int i = ts.index();
        try {
            do {
                if (ts.movePrevious()) continue;
                int n = 0;
                return n;
            } while (ts.token().id() != CppTokenId.NEW_LINE);
            while (true) {
                if (!ts.moveNext()) {
                    int n = 0;
                    return n;
                }
                switch ((CppTokenId)ts.token().id()) {
                    case WHITESPACE: {
                        break;
                    }
                    default: {
                        int d;
                        int n = d = ts.getTokenPosition();
                        return n;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(i);
            ts.moveNext();
        }
    }

    public int getLambdaIndent() {
        return this.lambdaIndent;
    }

    public int getLambdaParen() {
        return this.lambdaParen;
    }

    public void setLambdaParen(int lambdaParen) {
        this.lambdaParen = lambdaParen;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getSelfIndent() {
        return this.selfIndent;
    }

    public void setSelfIndent(int selfIndent) {
        this.selfIndent = selfIndent;
    }

    public int getIndex() {
        return this.index;
    }

    public String getText() {
        return this.text;
    }

    public CppTokenId getKind() {
        return this.kind;
    }

    public CppTokenId getImportantKind() {
        return this.importantKind;
    }

    public boolean isLikeToFunction() {
        return this.likeTo == LikeTo.function;
    }

    public void setLikeToFunction() {
        this.likeTo = LikeTo.function;
    }

    public boolean isLikeToArrayInitialization() {
        return this.likeTo == LikeTo.arrayInitialization || this.likeTo == LikeTo.unifiedInitialization;
    }

    public boolean isUniformInitialization() {
        return this.likeTo == LikeTo.unifiedInitialization;
    }

    public void setLikeToArrayInitialization() {
        this.likeTo = LikeTo.arrayInitialization;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.kind.name());
        if (this.importantKind != null && this.kind != this.importantKind) {
            buf.append("(").append(this.importantKind.name()).append(")");
        } else if (this.likeTo == LikeTo.function) {
            buf.append("(FUNCTION)");
        } else if (this.likeTo == LikeTo.arrayInitialization) {
            buf.append("(ARRAY_INITIALIZATION)");
        } else if (this.likeTo == LikeTo.unifiedInitialization) {
            buf.append("(UNIFORM_INITIALIZATION)");
        }
        return buf.toString();
    }

    public static enum LikeTo {
        unknown,
        function,
        arrayInitialization,
        unifiedInitialization;

    }
}

