/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class JGitConfig {
    public static final String CONFIG_CORE_SECTION = "core";
    public static final String CONFIG_REMOTE_SECTION = "remote";
    public static final String CONFIG_KEY_FILEMODE = "filemode";
    public static final String CONFIG_KEY_AUTOCRLF = "autocrlf";
    public static final String CONFIG_BRANCH_SECTION = "branch";
    public static final String CONFIG_KEY_AUTOSETUPMERGE = "autosetupmerge";
    public static final String CONFIG_KEY_REMOTE = "remote";
    public static final String CONFIG_KEY_MERGE = "merge";
    public static final String CONFIG_KEY_BARE = "bare";
    public static final String CONFIG_KEY_FF = "ff";
    public static final String CONFIG_KEY_URL = "url";
    public static final String CONFIG_KEY_PUSHURL = "pushurl";
    public static final String CONFIG_KEY_FETCH = "fetch";
    public static final String CONFIG_KEY_PUSH = "push";
    private static final String CONFIG_LOCATION = ".git/config";
    private final TreeMap<SectionKey, TreeMap<String, String>> map = new TreeMap();
    private final VCSFileProxy location;

    public JGitConfig(VCSFileProxy location) {
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        VCSFileProxy config = VCSFileProxy.createFileProxy((VCSFileProxy)this.location, (String)CONFIG_LOCATION);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(config.getInputStream(false), "UTF-8"));
            SectionKey section = null;
            this.map.clear();
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i >= 0) {
                    if (i == 0) continue;
                    line = line.substring(0, i);
                }
                line = line.replace('\t', ' ');
                if ((line = line.trim()).isEmpty()) continue;
                i = line.indexOf(91);
                int j = line.indexOf(93);
                if (i >= 0 && j > i) {
                    String s = line.substring(i + 1, j);
                    if ((i = s.indexOf(34)) > 0) {
                        String key = s.substring(0, i).trim();
                        String sub = s.substring(i + 1, s.length() - 1);
                        section = new SectionKey(key, sub);
                    } else {
                        section = new SectionKey(s, null);
                    }
                    this.map.put(section, new TreeMap());
                    continue;
                }
                i = line.indexOf(61);
                if (section == null || i <= 0) continue;
                String key = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                this.map.get(section).put(key, value);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        VCSFileProxy config = VCSFileProxy.createFileProxy((VCSFileProxy)this.location, (String)CONFIG_LOCATION);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)config), "UTF-8"));
            for (Map.Entry<SectionKey, TreeMap<String, String>> entry : this.map.entrySet()) {
                SectionKey key = entry.getKey();
                bw.write(91);
                bw.write(key.section);
                if (key.subSection != null) {
                    bw.write(" \"");
                    bw.write(key.subSection);
                    bw.write(34);
                }
                bw.write(93);
                bw.newLine();
                for (Map.Entry<String, String> e : entry.getValue().entrySet()) {
                    bw.write(9);
                    bw.write(e.getKey());
                    bw.write(" = ");
                    bw.write(e.getValue());
                    bw.newLine();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setString(String section, String subsection, String key, String value) {
        SectionKey storageKey = new SectionKey(section, subsection);
        TreeMap<String, String> storage = this.map.get(storageKey);
        if (storage == null) {
            storage = new TreeMap();
            this.map.put(storageKey, storage);
        }
        storage.put(key, value);
    }

    public String getString(String section, String subsection, String key) {
        SectionKey storageKey = new SectionKey(section, subsection);
        TreeMap<String, String> storage = this.map.get(storageKey);
        if (storage == null) {
            return null;
        }
        return storage.get(key);
    }

    public void setBoolean(String section, String subsection, String key, boolean b) {
        SectionKey storageKey = new SectionKey(section, subsection);
        TreeMap<String, String> storage = this.map.get(storageKey);
        if (storage == null) {
            storage = new TreeMap();
            this.map.put(storageKey, storage);
        }
        storage.put(key, Boolean.toString(b));
    }

    public boolean getBoolean(String section, String subsection, String key, boolean b) {
        SectionKey storageKey = new SectionKey(section, subsection);
        TreeMap<String, String> storage = this.map.get(storageKey);
        if (storage == null) {
            return false;
        }
        String val = storage.get(key);
        return Boolean.toString(true).equals(val);
    }

    public void unset(String section, String subsection, String key) {
        SectionKey storageKey = new SectionKey(section, subsection);
        TreeMap<String, String> storage = this.map.get(storageKey);
        if (storage != null) {
            storage.remove(key);
            if (storage.isEmpty()) {
                this.map.remove(storageKey);
            }
        }
    }

    public void unsetSection(String section, String subsection) {
        SectionKey storageKey = new SectionKey(section, subsection);
        this.map.remove(storageKey);
    }

    public Collection<String> getSubsections(String section) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<SectionKey, TreeMap<String, String>> entry : this.map.entrySet()) {
            SectionKey key = entry.getKey();
            if (!section.equals(key.section) || key.subSection == null) continue;
            res.add(key.subSection);
        }
        return res;
    }

    public Collection<String> getSections() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<SectionKey, TreeMap<String, String>> entry : this.map.entrySet()) {
            SectionKey key = entry.getKey();
            if (res.contains(key.section)) continue;
            res.add(key.section);
        }
        return res;
    }

    private static final class SectionKey
    implements Comparable<SectionKey> {
        private final String section;
        private final String subSection;

        private SectionKey(String section, String subSection) {
            this.section = section;
            this.subSection = subSection;
        }

        @Override
        public int compareTo(SectionKey o) {
            int res = this.section.compareTo(o.section);
            if (res == 0) {
                if (this.subSection == null && o.subSection == null) {
                    return 0;
                }
                if (this.subSection == null) {
                    return -1;
                }
                if (o.subSection == null) {
                    return 1;
                }
                return this.subSection.compareTo(o.subSection);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SectionKey other = (SectionKey)obj;
            if (!Objects.equals(this.section, other.section)) {
                return false;
            }
            return Objects.equals(this.subSection, other.subSection);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Objects.hashCode(this.section);
            hash = 83 * hash + Objects.hashCode(this.subSection);
            return hash;
        }

        public String toString() {
            if (this.subSection != null) {
                return "[" + this.section + " \"" + this.subSection + "\"]";
            }
            return "[" + this.section + "]";
        }
    }
}

