/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRepositoryState;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class JGitRepository {
    private final VCSFileProxy location;
    private final AtomicInteger counter = new AtomicInteger();
    private final JGitConfig config;
    private final AtomicBoolean loaded = new AtomicBoolean(false);

    public JGitRepository(VCSFileProxy location) {
        this.location = location;
        this.config = new JGitConfig(location);
    }

    public synchronized void increaseClientUsage() throws GitException {
        this.counter.incrementAndGet();
    }

    public synchronized void decreaseClientUsage() {
        this.counter.decrementAndGet();
    }

    public VCSFileProxy getLocation() {
        return this.location;
    }

    public VCSFileProxy getMetadataLocation() {
        return VCSFileProxy.createFileProxy((VCSFileProxy)this.location, (String)".git");
    }

    public GitRepositoryState getRepositoryState() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JGitConfig getConfig() {
        AtomicBoolean atomicBoolean = this.loaded;
        synchronized (atomicBoolean) {
            if (!this.loaded.get()) {
                this.config.load();
                this.loaded.set(true);
            }
            return this.config;
        }
    }
}

