/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.GitRef;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.TransportCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class ListRemoteTagsCommand
extends TransportCommand {
    private Map<String, String> remoteTags;
    private final String remoteUrl;
    private Collection<GitRef> refs;
    private final ProgressMonitor monitor;

    public ListRemoteTagsCommand(JGitRepository repository, GitClassFactory gitFactory, String remoteRepositoryUrl, ProgressMonitor monitor) {
        super(repository, gitFactory, remoteRepositoryUrl, monitor);
        this.remoteUrl = remoteRepositoryUrl;
        this.monitor = monitor;
    }

    private void processRefs() {
        this.remoteTags = new LinkedHashMap<String, String>();
        this.remoteTags.putAll(Utils.refsToTags(this.refs));
    }

    public Map<String, String> getTags() {
        return this.remoteTags;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "ls-remote");
        this.addArgument(0, "--tags");
        this.addArgument(0, this.remoteUrl);
    }

    @Override
    protected final void runTransportCommand() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.refs = new ArrayList<GitRef>();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        ListRemoteTagsCommand.this.parseListRemoreTagsOutput(output);
                    }
                }.runCLI();
                this.processRefs();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parseListRemoreTagsOutput(String output) {
        for (String line : output.split("\n")) {
            String[] s;
            if (line.indexOf(94) >= 0 || (s = line.split("\\s")).length < 2) continue;
            String revision = s[0];
            String name = s[1];
            this.refs.add(new GitRef(name, revision));
        }
    }
}

