/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.Security;
import org.openide.util.NbBundle;

public class SecurityTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Role"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Entity_Name"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Actions")};
    private static final String[] attrNames = new String[]{"Role", "EntityName", "Actions"};
    private Security security;
    private HibernateConfiguration configuration;

    public SecurityTableModel(HibernateConfiguration configuration) {
        this.configuration = configuration;
        this.security = configuration.getSecurity();
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.security == null) {
            return null;
        }
        String attrValue = this.security.getAttributeValue("Grant", row, attrNames[column]);
        return attrValue;
    }

    @Override
    public int getRowCount() {
        if (this.security == null) {
            return 0;
        }
        return this.security.sizeGrant();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addRow(String[] values) {
        if (this.security == null) {
            this.security = this.configuration.newSecurity();
            this.configuration.setSecurity(this.security);
        }
        int row = this.security.addGrant(true);
        for (int i = 0; i < attrNames.length; ++i) {
            this.security.setAttributeValue("Grant", row, attrNames[i], values[i]);
        }
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int row, String[] values) {
        for (int i = 0; i < attrNames.length; ++i) {
            this.security.setAttributeValue("Grant", row, attrNames[i], values[i]);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.security.removeGrant(row);
        this.fireTableRowsDeleted(row, row);
    }
}

