/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.makefile.wizard.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public class BuildOutputPanel
extends DirectoryChooserPanel {
    static final long serialVersionUID = 2730227827286861351L;
    private int key;
    private boolean initialized;

    public BuildOutputPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_BuildOutputPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_TargetDirectory"), 2);
        this.getLabel().setLabelFor(this.getText());
        this.getLabel().setDisplayedMnemonic(this.getString("MNEM_TargetDirectory").charAt(0));
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        TargetData target = this.getMakefileData().getTarget(key);
        String cwd = this.getMakefileData().getBaseDirectory(true);
        String odir = CndPathUtilities.expandPath((String)target.getOutputDirectory());
        File outdir = null;
        File outpar = null;
        File cwf = null;
        if (odir.length() > 0 && !odir.equals(cwd)) {
            outdir = odir.startsWith(File.separator) ? new File(odir) : new File(cwd, odir);
            outpar = outdir.getParentFile();
            cwf = new File(cwd);
        }
        if (outdir != null && !outdir.equals(cwf)) {
            if (!outdir.exists()) {
                if (outpar == null || !outpar.canWrite()) {
                    this.warn(msgs, WARN_CANNOT_CREATE_OUTPUT_DIR, outdir.getPath());
                }
            } else if (!outdir.canWrite()) {
                this.warn(msgs, WARN_CANNOT_WRITE_TO_OUTPUT_DIR, outdir.getPath());
            }
        }
    }

    @Override
    public void addNotify() {
        String od;
        TargetData target = this.getMakefileData().getCurrentTarget();
        String real_od = od = target.getOutputDirectory();
        this.key = target.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (od.charAt(0) == '$') {
            od = CndPathUtilities.expandPath((String)real_od);
        }
        if (od.charAt(0) == '/' || od.charAt(0) == '~') {
            this.getText().setText(real_od);
        } else {
            this.getText().setText(CndPathUtilities.getRelativePath((String)this.getMakefileData().getBaseDirectory(), (String)real_od));
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JTextField tf = this.getText();
        if (tf != null) {
            TargetData target = this.getMakefileData().getTarget(this.key);
            String od = tf.getText();
            if (od == null) {
                od = ".";
            }
            if ((od = od.trim()).length() > 1) {
                od = CndPathUtilities.trimpath((String)od);
            }
            if (od.length() == 0) {
                od = ".";
            }
            target.setOutputDirectory(od);
        }
    }
}

