/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import org.netbeans.api.visual.action.ContiguousSelectEvent;
import org.netbeans.api.visual.action.ContiguousSelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public final class ContiguousSelectAction
extends WidgetAction.Adapter {
    private ContiguousSelectProvider provider;
    private Widget previousWidget;
    private Point previousLocalLocation;

    public ContiguousSelectAction(ContiguousSelectProvider provider) {
        this.provider = provider;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        Point localLocation = event.getPoint();
        if ((event.getButton() & 3) != 0 && this.process(widget, localLocation, event.getModifiersEx())) {
            return WidgetAction.State.CHAIN_ONLY;
        }
        return WidgetAction.State.REJECTED;
    }

    private boolean process(Widget widget, Point localLocation, int modifiers) {
        boolean shift;
        boolean ctrl = (modifiers & 0x80) != 0;
        boolean bl = shift = (modifiers & 0x40) != 0;
        ContiguousSelectEvent.SelectionType type = ctrl ? (shift ? ContiguousSelectEvent.SelectionType.ADDITIVE_CONTIGUOUS : ContiguousSelectEvent.SelectionType.ADDITIVE_NON_CONTIGUOUS) : (shift ? ContiguousSelectEvent.SelectionType.REPLACE_CONTIGUOUS : ContiguousSelectEvent.SelectionType.REPLACE_NON_CONTIGUOUS);
        ContiguousSelectEvent providerEvent = ContiguousSelectEvent.create(this.previousWidget, this.previousLocalLocation, widget, localLocation, type);
        if (this.provider.isSelectionAllowed(providerEvent)) {
            this.provider.select(providerEvent);
            if (!shift) {
                this.previousWidget = widget;
                this.previousLocalLocation = localLocation;
            }
            return true;
        }
        return false;
    }

    @Override
    public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (event.getKeyChar() == ' ' && this.process(widget, null, event.getModifiers())) {
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }
}

