/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.openide.awt.HtmlRenderer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public class SourceLevelComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ListDataListener {
    private static final SpecificationVersion VERSION_8 = new SpecificationVersion("8.0");
    private static final String VERSION_PREFIX = "1.";
    private static final int INITIAL_VERSION_MINOR = 3;
    private final ComboBoxModel j2sePlatformModel;
    private final ComboBoxModel j2mePlatformModel;
    private String originalSourceLevel;
    private String selectedSourceLevel;
    private SourceLevel[] sourceLevelCache;

    public SourceLevelComboBoxModel(@NonNull ComboBoxModel j2sePlatform, @NonNull ComboBoxModel j2mePlatform, @NonNull String originalSourceLevel) {
        this.j2sePlatformModel = j2sePlatform;
        this.j2mePlatformModel = j2mePlatform;
        this.originalSourceLevel = originalSourceLevel;
        this.selectedSourceLevel = originalSourceLevel;
        this.j2sePlatformModel.addListDataListener(this);
        this.j2mePlatformModel.addListDataListener(this);
    }

    private SourceLevel[] getSourceLevels() {
        if (this.sourceLevelCache == null) {
            SpecificationVersion lower = this.getLowerSpecificationVersion();
            ArrayList<SourceLevel> sourceLevels = new ArrayList<SourceLevel>();
            if (lower != null) {
                SpecificationVersion originalVersion;
                int index = 3;
                SpecificationVersion template = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index));
                while (template.compareTo((Object)lower) <= 0) {
                    sourceLevels.add(new SourceLevel(VERSION_PREFIX + Integer.toString(index)));
                    template = new SpecificationVersion(VERSION_PREFIX + Integer.toString(++index));
                }
                if (this.originalSourceLevel != null && (originalVersion = new SpecificationVersion(this.originalSourceLevel)).compareTo((Object)lower) > 0) {
                    sourceLevels.add(new SourceLevel(this.originalSourceLevel, false));
                }
            }
            this.sourceLevelCache = sourceLevels.toArray(new SourceLevel[0]);
        }
        return this.sourceLevelCache;
    }

    private SpecificationVersion getLowerSpecificationVersion() {
        JavaPlatform selectedJ2SE = PlatformUiSupport.getPlatform((Object)this.j2sePlatformModel.getSelectedItem());
        JavaPlatform selectedJ2ME = (JavaPlatform)this.j2mePlatformModel.getSelectedItem();
        SpecificationVersion specVersionJ2SE = null;
        SpecificationVersion specVersionJ2ME = null;
        if (selectedJ2SE != null) {
            specVersionJ2SE = selectedJ2SE.getSpecification().getVersion();
        }
        if (selectedJ2ME != null) {
            SpecificationVersion specificationVersion = specVersionJ2ME = VERSION_8.compareTo((Object)selectedJ2ME.getSpecification().getVersion()) <= 0 ? new SpecificationVersion("1.8") : new SpecificationVersion("1.3");
        }
        if (specVersionJ2SE != null && specVersionJ2ME != null) {
            SpecificationVersion lower = specVersionJ2SE.compareTo(specVersionJ2ME) <= 0 ? specVersionJ2SE : specVersionJ2ME;
            return lower;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
        synchronized (sourceLevelComboBoxModel) {
            this.sourceLevelCache = null;
        }
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public int getSize() {
        return this.getSourceLevels().length;
    }

    @Override
    public Object getElementAt(int index) {
        SourceLevel[] sourceLevels = this.getSourceLevels();
        assert (index >= 0 && index < sourceLevels.length);
        return sourceLevels[index];
    }

    @Override
    public void setSelectedItem(Object anItem) {
        SourceLevel level = (SourceLevel)anItem;
        this.selectedSourceLevel = level == null ? null : level.getSourceLevel();
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        for (SourceLevel level : this.getSourceLevels()) {
            if (!level.getSourceLevel().equals(this.selectedSourceLevel)) continue;
            return level;
        }
        return null;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.resetCache();
    }

    public static final class SourceLevelListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String message = null;
            if (value == null || value.equals(" ")) {
                message = " ";
            } else {
                assert (value instanceof SourceLevel);
                SourceLevel sourceLevel = (SourceLevel)value;
                message = sourceLevel.isValid() ? sourceLevel.getDisplayName() : "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_InvalidSourceLevel", (Object)sourceLevel.getDisplayName());
            }
            return this.delegate.getListCellRendererComponent(list, message, index, isSelected, cellHasFocus);
        }
    }

    public static class SourceLevel {
        private String sourceLevel;
        private boolean valid;

        public SourceLevel(String sourceLevel) {
            this(sourceLevel, true);
        }

        public SourceLevel(String sourceLevel, boolean valid) {
            this.sourceLevel = sourceLevel;
            this.valid = valid;
        }

        public String getSourceLevel() {
            return this.sourceLevel;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setSourceLevel(String sourceLevel) {
            this.sourceLevel = sourceLevel;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public String getDisplayName() {
            Double levelValue = Double.valueOf(this.sourceLevel);
            if (levelValue < 1.5) {
                return "JDK " + this.sourceLevel;
            }
            return "JDK " + this.sourceLevel.substring(this.sourceLevel.lastIndexOf(".") + 1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceLevel) {
                return this.getSourceLevel().equals(((SourceLevel)obj).getSourceLevel());
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + Objects.hashCode(this.sourceLevel);
            return hash;
        }
    }
}

