/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.j2me.project.ui.customizer.AddPushRegistryPanel;
import org.netbeans.modules.j2me.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.j2me.project.ui.customizer.MIDletScanner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class J2MEPushRegistryPanel
extends JPanel {
    protected final JTable table;
    private final StorableTableModel tableModel;
    private final DefaultComboBoxModel cbmClassesForAdd = new DefaultComboBoxModel();
    protected HashSet<String> classes;
    private final J2MEProjectProperties uiProperties;
    private final ListSelectionListener listSelectionListener;
    private final ChangeListener changeListener;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bMoveDown;
    private JButton bMoveUp;
    private JButton bRemove;
    private JPanel errorPanel;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public J2MEPushRegistryPanel(J2MEProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"ACSN_Push"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"ACSD_Push"));
        this.tableModel = this.uiProperties.PUSH_REGISTRY_TABLE_MODEL;
        this.table = new JTable(this.tableModel);
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
                if (J2MEPushRegistryPanel.this.classes != null && !J2MEPushRegistryPanel.this.classes.containsAll(J2MEPushRegistryPanel.this.tableModel.getClasses())) {
                    ((ErrorPanel)J2MEPushRegistryPanel.this.errorPanel).setErrorBundleMessage("ERR_CustMIDlets_WrongMIDlets");
                }
            }
        });
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                boolean enabled = J2MEPushRegistryPanel.this.table.isEnabled() && J2MEPushRegistryPanel.this.table.getSelectedRow() >= 0;
                J2MEPushRegistryPanel.this.bEdit.setEnabled(enabled);
                J2MEPushRegistryPanel.this.bRemove.setEnabled(enabled);
                J2MEPushRegistryPanel.this.bMoveUp.setEnabled(enabled && J2MEPushRegistryPanel.this.table.getSelectedRow() > 0);
                J2MEPushRegistryPanel.this.bMoveDown.setEnabled(enabled && J2MEPushRegistryPanel.this.table.getSelectedRow() < J2MEPushRegistryPanel.this.tableModel.getRowCount() - 1);
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setResizable(true);
        col.setPreferredWidth(150);
        col = this.table.getColumnModel().getColumn(1);
        col.setResizable(true);
        col.setPreferredWidth(100);
        col = this.table.getColumnModel().getColumn(2);
        col.setResizable(true);
        col.setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setForeground(isSelected ? table.getSelectionForeground() : (column == 0 && J2MEPushRegistryPanel.this.classes != null && !J2MEPushRegistryPanel.this.classes.contains(value) ? Color.RED : table.getForeground()));
                return component;
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    J2MEPushRegistryPanel.this.bEditActionPerformed(null);
                }
            }
        });
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                J2MEPushRegistryPanel.this.classes = new HashSet();
                for (int i = 0; i < J2MEPushRegistryPanel.this.cbmClassesForAdd.getSize(); ++i) {
                    J2MEPushRegistryPanel.this.classes.add((String)J2MEPushRegistryPanel.this.cbmClassesForAdd.getElementAt(i));
                }
                J2MEPushRegistryPanel.this.tableModel.fireTableDataChanged();
            }
        };
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.classes = null;
        MIDletScanner scanner = MIDletScanner.getDefault(this.uiProperties);
        scanner.scan(this.cbmClassesForAdd, null, this.changeListener);
        String[] propertyNames = this.uiProperties.PUSH_REGISTRY_PROPERTY_NAMES;
        String[] values = new String[propertyNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.uiProperties.getEvaluator().getProperty(propertyNames[i]);
        }
        this.tableModel.setDataDelegates(values);
        this.table.setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.listSelectionListener.valueChanged(null);
    }

    private void initComponents() {
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.bMoveUp = new JButton();
        this.bMoveDown = new JButton();
        this.errorPanel = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"J2MEPushRegistryPanel.lTable.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"J2MEPushRegistryPanel.bAdd.text"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEPushRegistryPanel.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 8);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"J2MEPushRegistryPanel.bEdit.text"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEPushRegistryPanel.this.bEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 8);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"J2MEPushRegistryPanel.bRemove.text"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEPushRegistryPanel.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 8);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bMoveUp, (String)NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"J2MEPushRegistryPanel.bMoveUp.text"));
        this.bMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEPushRegistryPanel.this.bMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 8);
        this.add((Component)this.bMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bMoveDown, (String)NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"J2MEPushRegistryPanel.bMoveDown.text"));
        this.bMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEPushRegistryPanel.this.bMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 8);
        this.add((Component)this.bMoveDown, gridBagConstraints);
        GroupLayout errorPanelLayout = new GroupLayout(this.errorPanel);
        this.errorPanel.setLayout(errorPanelLayout);
        errorPanelLayout.setHorizontalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        errorPanelLayout.setVerticalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void bAddActionPerformed(ActionEvent evt) {
        final AddPushRegistryPanel add = new AddPushRegistryPanel(this.cbmClassesForAdd);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"TITLE_AddPush"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    int row = J2MEPushRegistryPanel.this.tableModel.addRow(add.getClazz(), add.getSender(), add.getString());
                    J2MEPushRegistryPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bEditActionPerformed(ActionEvent evt) {
        final int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        final AddPushRegistryPanel add = new AddPushRegistryPanel(this.cbmClassesForAdd, (String)this.tableModel.getValueAt(row, 0), (String)this.tableModel.getValueAt(row, 1), (String)this.tableModel.getValueAt(row, 2));
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"TITLE_EditPush"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    J2MEPushRegistryPanel.this.tableModel.setRow(row, add.getClazz(), add.getSender(), add.getString());
                    J2MEPushRegistryPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    private void bMoveUpActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i <= 0) {
            return;
        }
        this.tableModel.moveUp(i);
        this.table.getSelectionModel().setSelectionInterval(--i, i);
    }

    private void bMoveDownActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i >= this.tableModel.getRowCount() - 1) {
            return;
        }
        this.tableModel.moveDown(i);
        this.table.getSelectionModel().setSelectionInterval(++i, i);
    }

    static class StorableTableModel
    extends AbstractTableModel {
        public static final String PREFIX = "MIDlet-Push-";
        private static final int[] COLUMN_MAP = new int[]{1, 2, 0};
        private HashMap<String, String> map = new HashMap();
        private int rows = 0;
        private static final long serialVersionUID = 920375326055211848L;
        private final J2MEProjectProperties uiProperties;
        private boolean dataDelegatesWereSet = false;

        public StorableTableModel(J2MEProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        public Set<String> getClasses() {
            HashSet<String> classes = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                classes.add((String)this.getValueAt(i, 0));
            }
            return classes;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"LBL_Push_Column_Class");
                }
                case 1: {
                    return NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"LBL_Push_Column_Sender");
                }
                case 2: {
                    return NbBundle.getMessage(J2MEPushRegistryPanel.class, (String)"LBL_Push_Column_String");
                }
            }
            return null;
        }

        public int addRow(String clazz, String sender, String string) {
            ++this.rows;
            this.setRow(this.rows - 1, string + ',' + clazz + ',' + sender);
            this.fireTableRowsInserted(this.rows - 1, this.rows - 1);
            return this.rows - 1;
        }

        private String getRow(int row) {
            assert (row < this.rows);
            String value = this.map.get(PREFIX + String.valueOf(row + 1));
            return value == null ? ",," : value;
        }

        private void setRow(int row, String value) {
            assert (row < this.rows);
            this.map.put(PREFIX + String.valueOf(row + 1), value);
        }

        public void removeRow(int row) {
            for (int i = row; i < this.rows - 1; ++i) {
                this.setRow(i, this.getRow(i + 1));
            }
            this.map.remove(PREFIX + String.valueOf(this.rows));
            --this.rows;
            this.fireTableRowsDeleted(row, row);
        }

        public void moveUp(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row - 1));
            this.setRow(row - 1, r);
            this.fireTableRowsUpdated(row - 1, row);
        }

        public void moveDown(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row + 1));
            this.setRow(row + 1, r);
            this.fireTableRowsUpdated(row, row + 1);
        }

        @Override
        public Object getValueAt(int row, int column) {
            assert (column < 3);
            return this.getRow(row).split(",", 3)[COLUMN_MAP[column]].trim();
        }

        public synchronized Object[] getDataDelegates() {
            if (!this.dataDelegatesWereSet) {
                String[] propertyNames = this.uiProperties.PUSH_REGISTRY_PROPERTY_NAMES;
                String[] values = new String[propertyNames.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.uiProperties.getEvaluator().getProperty(propertyNames[i]);
                }
                this.setDataDelegates(values);
            }
            return new Object[]{this.map};
        }

        public synchronized void setDataDelegates(String[] data) {
            this.map = data[0] == null ? new HashMap() : (HashMap)this.uiProperties.decode(data[0]);
            this.rows = 0;
            for (String key : this.map.keySet()) {
                if (!key.startsWith(PREFIX)) continue;
                try {
                    int i = Integer.parseInt(key.substring(PREFIX.length()));
                    if (i <= this.rows) continue;
                    this.rows = i;
                }
                catch (NumberFormatException nfe) {
                    assert (false) : nfe;
                }
            }
            this.fireTableDataChanged();
            this.dataDelegatesWereSet = true;
        }

        public void setRow(int row, String clazz, String sender, String string) {
            this.setRow(row, string + ',' + clazz + ',' + sender);
            this.fireTableRowsUpdated(row, row);
        }
    }
}

