/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class J2MERunPanel
extends JPanel
implements HelpCtx.Provider {
    private final J2MEProjectProperties.DataSource[] data;
    private final Map<String, Map<String, String>> configs;
    private final J2MEProjectProperties uiProperties;
    private JRadioButton OTARadio;
    private ButtonGroup buttonGroupRun;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSeparator;
    private JTextField debugTimeoutField;
    private JLabel debugTimeoutLabel;
    private JPanel extPanel;
    private Box.Filler filler1;
    private JLabel jLabel2;
    private JLabel labelCommandlineOptions;
    private JLabel labelRunMethod;
    private JPanel panelJ2MERunOptions;
    private JPanel panelRunMethod;
    private JLabel runNoteLabel;
    private JRadioButton standardRadio;
    private JTextField texfieldCmdOptions;

    public J2MERunPanel(J2MEProjectProperties properties) {
        this.initComponents();
        this.standardRadio.setActionCommand("STANDARD");
        this.OTARadio.setActionCommand("OTA");
        this.uiProperties = properties;
        this.configs = this.uiProperties.RUN_CONFIGS;
        this.data = new J2MEProjectProperties.DataSource[]{new TextDataSource("application.args", this.labelCommandlineOptions, this.texfieldCmdOptions, this.configCombo, this.configs), new TextDataSource("debugger.timeout", this.debugTimeoutLabel, this.debugTimeoutField, this.configCombo, this.configs), new J2MEProjectProperties.ButtonGroupDataSource("run.method", this.buttonGroupRun, this.configCombo, this.configs)};
        this.configChanged(this.uiProperties.activeConfig);
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        this.configCombo.setModel(this.uiProperties.CONFIGS_MODEL);
    }

    private void initComponents() {
        this.buttonGroupRun = new ButtonGroup();
        this.configPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.configSeparator = new JSeparator();
        this.panelJ2MERunOptions = new JPanel();
        this.labelCommandlineOptions = new JLabel();
        this.texfieldCmdOptions = new JTextField();
        this.jLabel2 = new JLabel();
        this.debugTimeoutLabel = new JLabel();
        this.debugTimeoutField = new JTextField();
        this.panelRunMethod = new JPanel();
        this.standardRadio = new JRadioButton();
        this.OTARadio = new JRadioButton();
        this.labelRunMethod = new JLabel();
        this.runNoteLabel = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.extPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.configPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.configLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.configPanel.add((Component)this.configLabel, gridBagConstraints);
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MERunPanel.this.configComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.configNew.text"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MERunPanel.this.configNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configNew, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.configDel.text"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MERunPanel.this.configDelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configDel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.configPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.configSeparator, gridBagConstraints);
        this.panelJ2MERunOptions.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labelCommandlineOptions, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.labelCommandlineOptions.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 5);
        this.panelJ2MERunOptions.add((Component)this.labelCommandlineOptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.panelJ2MERunOptions.add((Component)this.texfieldCmdOptions, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelJ2MERunOptions.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.debugTimeoutLabel, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.debugTimeoutLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(15, 0, 8, 5);
        this.panelJ2MERunOptions.add((Component)this.debugTimeoutLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 5, 0);
        this.panelJ2MERunOptions.add((Component)this.debugTimeoutField, gridBagConstraints);
        this.buttonGroupRun.add(this.standardRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.standardRadio, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.standardRadio.text"));
        this.buttonGroupRun.add(this.OTARadio);
        Mnemonics.setLocalizedText((AbstractButton)this.OTARadio, (String)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.OTARadio.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelRunMethod, (String)MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2me/project/ui/customizer/Bundle").getString("J2MERunPanel.labelRunMethod.text"), new Object[0]));
        GroupLayout panelRunMethodLayout = new GroupLayout(this.panelRunMethod);
        this.panelRunMethod.setLayout(panelRunMethodLayout);
        panelRunMethodLayout.setHorizontalGroup(panelRunMethodLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRunMethodLayout.createSequentialGroup().addComponent(this.labelRunMethod).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.standardRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.OTARadio).addContainerGap(-1, Short.MAX_VALUE)));
        panelRunMethodLayout.setVerticalGroup(panelRunMethodLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRunMethodLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(panelRunMethodLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.standardRadio).addComponent(this.OTARadio).addComponent(this.labelRunMethod))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 512;
        this.panelJ2MERunOptions.add((Component)this.panelRunMethod, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.runNoteLabel, (String)MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2me/project/ui/customizer/Bundle").getString("J2MERunPanel.runNoteLabel.text"), new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelJ2MERunOptions.add((Component)this.runNoteLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.panelJ2MERunOptions.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.panelJ2MERunOptions, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    private void configNewActionPerformed(ActionEvent evt) {
        this.createNewConfiguration();
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.uiProperties.activeConfig = null;
    }

    private void configChanged(String activeConfig) {
        this.uiProperties.CONFIGS_MODEL = new DefaultComboBoxModel();
        this.uiProperties.CONFIGS_MODEL.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)J2MERunPanel.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            this.uiProperties.CONFIGS_MODEL.addElement(c);
        }
        this.configCombo.setModel(this.uiProperties.CONFIGS_MODEL);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> m = this.configs.get(activeConfig);
        if (m != null) {
            for (J2MEProjectProperties.DataSource ds : this.data) {
                ds.update(activeConfig);
            }
        }
        this.configDel.setEnabled(activeConfig != null);
    }

    private void createNewConfiguration() {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.prompt"), NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (config.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.empty", (Object)config), 2));
            return;
        }
        if (this.configs.get(config) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.duplicate", (Object)config), 2));
            return;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (!name.equals(config)) {
            m.put("$label", name);
        }
        this.configs.put(config, m);
        this.configChanged(config);
        this.uiProperties.activeConfig = config;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configChanged(this.uiProperties.activeConfig);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.J2MERunPanel");
    }

    private static class TextDataSource
    extends J2MEProjectProperties.DataSource {
        private final JTextComponent textComp;

        public TextDataSource(@NonNull String propName, @NonNull JLabel label, final @NonNull JTextComponent textComp, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            super(propName, label, configCombo, configs);
            Parameters.notNull((CharSequence)"textComp", (Object)textComp);
            this.textComp = textComp;
            this.textComp.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TextDataSource.this.changed(textComp.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TextDataSource.this.changed(textComp.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }

        @Override
        public String getPropertyValue() {
            return this.textComp.getText();
        }

        @Override
        public void update(@NullAllowed String activeConfig) {
            this.textComp.setText(this.getPropertyValue(activeConfig, this.getPropertyName()));
        }
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            if (config == null) {
                label = null;
            } else if (config.length() > 0) {
                Map m = (Map)J2MERunPanel.this.configs.get(config);
                String string = label = m != null ? (String)m.get("$label") : null;
                if (label == null) {
                    label = config;
                }
            } else {
                label = NbBundle.getBundle((String)"org.netbeans.modules.java.j2seproject.Bundle").getString("J2SEConfigurationProvider.default.label");
            }
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

