/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityChecker;
import org.openide.nodes.Node;

public class SecurityCheckerRegistry {
    private static SecurityCheckerRegistry instance;
    private List<SecurityChecker> checkers = Collections.synchronizedList(new LinkedList());
    private static final Logger logger;

    private SecurityCheckerRegistry() {
    }

    public static SecurityCheckerRegistry getDefault() {
        if (instance == null) {
            instance = new SecurityCheckerRegistry();
        }
        return instance;
    }

    public void register(SecurityChecker checker) {
        if (checker != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registerChecker: " + checker + ", dName: " + checker.getDisplayName());
            }
            this.checkers.add(checker);
        }
    }

    public void unregister(SecurityChecker checker) {
        if (checker != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "unregisterChecker: " + checker + ", dName: " + checker.getDisplayName());
            }
            this.checkers.remove(checker);
        }
    }

    public Collection<SecurityChecker> getSecurityCheckers() {
        return Collections.unmodifiableList(this.checkers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNonWsitSecurityEnabled(Node node, JaxWsModel jaxWsModel) {
        Collection<SecurityChecker> secCheckers;
        if (node != null && jaxWsModel != null && (secCheckers = this.getSecurityCheckers()) != null && !secCheckers.isEmpty()) {
            for (SecurityChecker sc : secCheckers) {
                boolean secEnabled = false;
                try {
                    secEnabled = sc.isSecurityEnabled(node, jaxWsModel);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception from SecurityChecker: ", e);
                }
                finally {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "securityEnabled: " + secEnabled + ", " + sc + ", dName: " + sc.getDisplayName() + ", node: " + node + ", jaxwsmodel: " + jaxWsModel);
                    }
                }
                if (!secEnabled) continue;
                return true;
            }
        }
        return false;
    }

    static {
        logger = Logger.getLogger("org.netbeans.modules.websvc.wsitconf.spi");
    }
}

