/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.VersionedFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;

public abstract class ProfileBaseForm
extends JPanel {
    protected boolean inSync = false;
    protected WSDLComponent comp;
    protected SecurityProfile secProfile = null;
    protected ConfigVersion cfgVersion = null;

    private ProfileBaseForm() {
    }

    protected ProfileBaseForm(WSDLComponent comp, SecurityProfile secProfile) {
        this.comp = comp;
        this.secProfile = secProfile;
        this.cfgVersion = secProfile instanceof VersionedFeature ? ((VersionedFeature)((Object)secProfile)).getVersion() : PolicyModelHelper.getConfigVersion(comp);
    }

    protected void setCombo(JComboBox combo, boolean second) {
        combo.setSelectedIndex(second ? 1 : 0);
    }

    protected void setCombo(JComboBox combo, String item) {
        if (item == null) {
            combo.setSelectedIndex(0);
        } else {
            combo.setSelectedItem(item);
        }
    }

    protected void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    protected void fillKeySize(JComboBox keySizeCombo) {
        this.fillKeySize(keySizeCombo, false);
    }

    protected void fillKeySize(JComboBox keySizeCombo, boolean publicKey) {
        keySizeCombo.removeAllItems();
        if (publicKey) {
            keySizeCombo.addItem("       ");
            keySizeCombo.addItem(ComboConstants.ISSUED_KEYSIZE_1024);
            keySizeCombo.addItem(ComboConstants.ISSUED_KEYSIZE_2048);
            keySizeCombo.addItem(ComboConstants.ISSUED_KEYSIZE_3072);
        } else {
            keySizeCombo.addItem(ComboConstants.ISSUED_KEYSIZE_128);
            keySizeCombo.addItem(ComboConstants.ISSUED_KEYSIZE_192);
            keySizeCombo.addItem(ComboConstants.ISSUED_KEYSIZE_256);
        }
    }

    protected void fillWssCombo(JComboBox wssCombo) {
        wssCombo.removeAllItems();
        wssCombo.addItem(ComboConstants.WSS10);
        wssCombo.addItem(ComboConstants.WSS11);
    }

    protected void fillSamlCombo(JComboBox samlVersionCombo) {
        samlVersionCombo.removeAllItems();
        samlVersionCombo.addItem(ComboConstants.SAML_V1010);
        samlVersionCombo.addItem(ComboConstants.SAML_V1011);
        samlVersionCombo.addItem(ComboConstants.SAML_V1110);
        samlVersionCombo.addItem(ComboConstants.SAML_V1111);
        samlVersionCombo.addItem(ComboConstants.SAML_V2011);
    }

    protected void fillLayoutCombo(JComboBox layoutCombo) {
        layoutCombo.removeAllItems();
        layoutCombo.addItem(ComboConstants.STRICT);
        layoutCombo.addItem(ComboConstants.LAX);
        layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        layoutCombo.addItem(ComboConstants.LAXTSLAST);
    }

    protected void fillAlgoSuiteCombo(JComboBox algoSuiteCombo) {
        algoSuiteCombo.removeAllItems();
        algoSuiteCombo.addItem(ComboConstants.BASIC256);
        algoSuiteCombo.addItem(ComboConstants.BASIC192);
        algoSuiteCombo.addItem(ComboConstants.BASIC128);
        algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
        algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
        algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
        algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
        algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
        algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
    }

    protected abstract void sync();

    protected abstract void enableDisable();

    protected abstract void setValue(JComponent var1);
}

