/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.HashMap;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10WsdlQName;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10WsdlUsingAddressing;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing13WsdlAddressing;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing13WsdlQName;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;

public class AddressingModelHelper {
    private static HashMap<ConfigVersion, AddressingModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private AddressingModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final AddressingModelHelper getInstance(ConfigVersion configVersion) {
        AddressingModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new AddressingModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    private static Addressing10WsdlUsingAddressing getUsingAddressing(Policy p) {
        return (Addressing10WsdlUsingAddressing)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, Addressing10WsdlUsingAddressing.class, false);
    }

    private static Addressing13WsdlAddressing getAddressing(Policy p) {
        return (Addressing13WsdlAddressing)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, Addressing13WsdlAddressing.class, false);
    }

    public static boolean isAddressingEnabled(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        if (p != null) {
            Addressing10WsdlUsingAddressing addrAssertion = AddressingModelHelper.getUsingAddressing(p);
            if (addrAssertion != null) {
                return true;
            }
            Addressing13WsdlAddressing addr13Assertion = AddressingModelHelper.getAddressing(p);
            if (addr13Assertion != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAddressing(WSDLComponent c, boolean optional) {
        WSDLModel model;
        boolean isTransaction;
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        if (c instanceof Binding) {
            c = pmh.createPolicy(c, false);
        }
        if (!(isTransaction = (model = c.getModel()).isIntransaction())) {
            model.startTransaction();
        }
        try {
            if (this.configVersion == ConfigVersion.CONFIG_1_0) {
                Addressing10WsdlUsingAddressing addrAssertion = (Addressing10WsdlUsingAddressing)pmh.createElement(c, Addressing10WsdlQName.USINGADDRESSING.getQName(), Addressing10WsdlUsingAddressing.class, false);
                addrAssertion.setOptional(optional);
            } else {
                Addressing13WsdlAddressing addrAssertion = (Addressing13WsdlAddressing)pmh.createElement(c, Addressing13WsdlQName.ADDRESSING.getQName(this.configVersion), Addressing13WsdlAddressing.class, false);
                addrAssertion.setOptional(optional);
            }
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }

    public static void disableAddressing(Binding b) {
        Policy p = PolicyModelHelper.getPolicyForElement((WSDLComponent)b);
        Addressing10WsdlUsingAddressing a10 = AddressingModelHelper.getUsingAddressing(p);
        Addressing13WsdlAddressing a13 = AddressingModelHelper.getAddressing(p);
        if (a10 != null) {
            PolicyModelHelper.removeElement((WSDLComponent)a10.getParent(), Addressing10WsdlUsingAddressing.class, false);
        }
        if (a13 != null) {
            PolicyModelHelper.removeElement((WSDLComponent)a13.getParent(), Addressing13WsdlAddressing.class, false);
        }
        PolicyModelHelper.cleanPolicies((WSDLComponent)b);
    }
}

