/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.SerialFieldTagImpl;

class SerializedForm {
    ListBuffer<MethodDoc> methods = new ListBuffer();
    private final ListBuffer<FieldDocImpl> fields = new ListBuffer();
    private boolean definesSerializableFields = false;
    private static final String SERIALIZABLE_FIELDS = "serialPersistentFields";
    private static final String READOBJECT = "readObject";
    private static final String WRITEOBJECT = "writeObject";
    private static final String READRESOLVE = "readResolve";
    private static final String WRITEREPLACE = "writeReplace";
    private static final String READOBJECTNODATA = "readObjectNoData";

    SerializedForm(DocEnv env, Symbol.ClassSymbol def, ClassDocImpl cd) {
        if (cd.isExternalizable()) {
            String[] readExternalParamArr = new String[]{"java.io.ObjectInput"};
            String[] writeExternalParamArr = new String[]{"java.io.ObjectOutput"};
            MethodDocImpl md = cd.findMethod("readExternal", readExternalParamArr);
            if (md != null) {
                this.methods.append(md);
            }
            if ((md = cd.findMethod("writeExternal", writeExternalParamArr)) != null) {
                this.methods.append(md);
                Tag[] tagArray = md.tags("serialData");
            }
        } else if (cd.isSerializable()) {
            Symbol.VarSymbol dsf = this.getDefinedSerializableFields(def);
            if (dsf != null) {
                this.definesSerializableFields = true;
                FieldDocImpl dsfDoc = env.getFieldDoc(dsf);
                this.fields.append(dsfDoc);
                this.mapSerialFieldTagImplsToFieldDocImpls(dsfDoc, env, def);
            } else {
                this.computeDefaultSerializableFields(env, def, cd);
            }
            this.addMethodIfExist(env, def, READOBJECT);
            this.addMethodIfExist(env, def, WRITEOBJECT);
            this.addMethodIfExist(env, def, READRESOLVE);
            this.addMethodIfExist(env, def, WRITEREPLACE);
            this.addMethodIfExist(env, def, READOBJECTNODATA);
        }
    }

    private Symbol.VarSymbol getDefinedSerializableFields(Symbol.ClassSymbol def) {
        Names names = def.name.table.names;
        for (Symbol sym : def.members().getSymbolsByName(names.fromString(SERIALIZABLE_FIELDS))) {
            Symbol.VarSymbol f;
            if (sym.kind != Kinds.Kind.VAR || ((f = (Symbol.VarSymbol)sym).flags() & 8L) == 0L || (f.flags() & 2L) == 0L) continue;
            return f;
        }
        return null;
    }

    private void computeDefaultSerializableFields(DocEnv env, Symbol.ClassSymbol def, ClassDocImpl cd) {
        for (Symbol sym : def.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            Symbol.VarSymbol f;
            if (sym == null || sym.kind != Kinds.Kind.VAR || ((f = (Symbol.VarSymbol)sym).flags() & 8L) != 0L || (f.flags() & 0x80L) != 0L) continue;
            FieldDocImpl fd = env.getFieldDoc(f);
            this.fields.prepend(fd);
        }
    }

    private void addMethodIfExist(DocEnv env, Symbol.ClassSymbol def, String methodName) {
        Names names = def.name.table.names;
        for (Symbol sym : def.members().getSymbolsByName(names.fromString(methodName))) {
            Symbol.MethodSymbol md;
            if (sym.kind != Kinds.Kind.MTH || ((md = (Symbol.MethodSymbol)sym).flags() & 8L) != 0L) continue;
            this.methods.append(env.getMethodDoc(md));
        }
    }

    private void mapSerialFieldTagImplsToFieldDocImpls(FieldDocImpl spfDoc, DocEnv env, Symbol.ClassSymbol def) {
        Names names = def.name.table.names;
        block0: for (SerialFieldTag tag : spfDoc.serialFieldTags()) {
            if (tag.fieldName() == null || tag.fieldType() == null) continue;
            Name fieldName = names.fromString(tag.fieldName());
            for (Symbol sym : def.members().getSymbolsByName(fieldName)) {
                if (sym.kind != Kinds.Kind.VAR) continue;
                Symbol.VarSymbol f = (Symbol.VarSymbol)sym;
                FieldDocImpl fdi = env.getFieldDoc(f);
                ((SerialFieldTagImpl)tag).mapToFieldDocImpl(fdi);
                continue block0;
            }
        }
    }

    FieldDoc[] fields() {
        return this.fields.toArray(new FieldDocImpl[this.fields.length()]);
    }

    MethodDoc[] methods() {
        return this.methods.toArray(new MethodDoc[this.methods.length()]);
    }

    boolean definesSerializableFields() {
        return this.definesSerializableFields;
    }
}

