/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;

public final class JavaRegexpUtils {
    public static final String TESTSUITE_PREFIX = "Testsuite: ";
    public static final String TESTSUITE_STATS_PREFIX = "Tests run: ";
    public static final String FLOAT_NUMBER_REGEX = "[0-9]*(?:\\.[0-9]+)?";
    public static final String SECONDS_REGEX = "s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    public static final String TESTSUITE_STATS_REGEX = "Tests run: +([0-9]+), +Failures: +([0-9]+), +Errors: +([0-9]+), +Time elapsed: +(.+)s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    public static final String TESTSUITE_STATS_190_REGEX = "Tests run: +([0-9]+), +Failures: +([0-9]+), +Errors: +([0-9]+),( +Skipped: +([0-9]+),)? +Time elapsed: +(.+)s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    public static final String OUTPUT_DELIMITER_PREFIX = "--------";
    public static final String STDOUT_LABEL = "Output";
    public static final String STDERR_LABEL = "Error";
    public static final String OUTPUT_DELIMITER_REGEX = "-{8,} (?:Standard (Output|Error)|-{3,}) -{8,}";
    public static final String TESTCASE_PREFIX = "Testcase: ";
    public static final String TESTCASE_ISSUE_REGEX = "\\p{Blank}*(?:(FAILED) *|(?i:.*\\berror\\b.*))";
    public static final String TESTCASE_HEADER_PLAIN_REGEX = "\\p{Blank}*((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)\\p{Blank}+took\\p{Blank}+(.+)s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    public static final String TESTCASE_HEADER_BRIEF_REGEX = "\\p{Blank}*((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*) *\\( *((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*) *\\) *:\\p{Blank}*(?:(FAILED) *|(?i:.*\\berror\\b.*))";
    public static final String TESTCASE_EXCEPTION_REGEX = "((?:(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*\\.?(?:Exception|Error|ComparisonFailure))|java\\.lang\\.Throwable)(?: *: *(.*))?";
    public static final String CALLSTACK_LINE_PREFIX = "at ";
    public static final String CALLSTACK_LINE_PREFIX_CATCH = "[catch] ";
    public static final String CALLSTACK_LINE_REGEX = "(?:\\t\\t?|  +| *\\t? *\\[catch\\] )at (?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)+(?:\\.<init>)?(?: ?\\([^()]+\\))?";
    public static final String NESTED_EXCEPTION_PREFIX = "Caused by: ";
    public static final String NESTED_EXCEPTION_REGEX = "((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*)(?:: (.*))?";
    public static final String LOCATION_IN_FILE_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?";
    public static final String XML_DECL_PREFIX = "<?xml";
    public static final String XML_SPACE_REGEX = "[ \\t\\r\\n]";
    public static final String XML_EQ_REGEX = "[ \\t\\r\\n]*=[ \\t\\r\\n]*";
    public static final String XML_ENC_REGEX = "[A-Za-z][-A-Za-z0-9._]*";
    public static final String XML_DECL_REGEX = "\\Q<?xml\\E[ \\t\\r\\n]+version[ \\t\\r\\n]*=[ \\t\\r\\n]*(?:\"1\\.0\"|'1\\.0')(?:[ \\t\\r\\n]+encoding[ \\t\\r\\n]*=[ \\t\\r\\n]*(['\"])[A-Za-z][-A-Za-z0-9._]*\\1)?(?:[ \\t\\r\\n]+standalone[ \\t\\r\\n]*=[ \\t\\r\\n]*(['\"])(?:yes|no)\\2)?[ \\t\\r\\n]*\\?>";
    public static final String TEST_LISTENER_PREFIX = "junit.framework.TestListener: ";
    public static final String TESTS_COUNT_PREFIX = "tests to run: ";
    public static final String START_OF_TEST_PREFIX = "startTest";
    public static final String END_OF_TEST_PREFIX = "endTest";
    public static final String ADD_FAILURE_PREFIX = "addFailure";
    public static final String ADD_ERROR_PREFIX = "addError";
    public static final String COMPARISON_REGEX = ".*expected:<(.*)\\[(.*)\\](.*)> but was:<(.*)\\[(.*)\\](.*)>.*";
    public static final String COMPARISON_HIDDEN_REGEX = ".*expected:<(.*)> but was:<(.*)>.*";
    public static final Pattern CLASSPATH_ARGS = Pattern.compile("\r?\n'-classpath'\r?\n'(.*)'\r?\n");
    public static final Pattern JAVA_EXECUTABLE = Pattern.compile("^Executing '(.*)' with arguments:$", 8);
    private static Reference<JavaRegexpUtils> instRef;
    private volatile Pattern fullJavaIdPattern;
    private volatile Pattern suiteStatsPattern;
    private volatile Pattern suiteStats190Pattern;
    private volatile Pattern outputDelimPattern;
    private volatile Pattern testcaseIssuePattern;
    private volatile Pattern testcaseExceptPattern;
    private volatile Pattern callstackLinePattern;
    private volatile Pattern nestedExceptPattern;
    private volatile Pattern locationInFilePattern;
    private volatile Pattern testcaseHeaderBriefPattern;
    private volatile Pattern testcaseHeaderPlainPattern;
    private volatile Pattern xmlDeclPattern;
    private volatile Pattern floatNumPattern;
    private volatile Pattern comparisonPattern;
    private volatile Pattern comparisonHiddenPattern;

    public static synchronized JavaRegexpUtils getInstance() {
        JavaRegexpUtils instance;
        JavaRegexpUtils javaRegexpUtils = instance = instRef != null ? instRef.get() : null;
        if (instance == null) {
            instance = new JavaRegexpUtils();
            instRef = new WeakReference<JavaRegexpUtils>(instance);
        }
        return instance;
    }

    private JavaRegexpUtils() {
    }

    public Pattern getFullJavaIdPattern() {
        if (this.fullJavaIdPattern == null) {
            this.fullJavaIdPattern = Pattern.compile("(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*");
        }
        return this.fullJavaIdPattern;
    }

    public Pattern getSuiteStatsPattern() {
        if (this.suiteStatsPattern == null) {
            this.suiteStatsPattern = Pattern.compile(TESTSUITE_STATS_REGEX);
        }
        return this.suiteStatsPattern;
    }

    public Pattern getSuiteStats190Pattern() {
        if (this.suiteStats190Pattern == null) {
            this.suiteStats190Pattern = Pattern.compile(TESTSUITE_STATS_190_REGEX);
        }
        return this.suiteStats190Pattern;
    }

    public Pattern getOutputDelimPattern() {
        if (this.outputDelimPattern == null) {
            this.outputDelimPattern = Pattern.compile(OUTPUT_DELIMITER_REGEX);
        }
        return this.outputDelimPattern;
    }

    public Pattern getTestcaseHeaderBriefPattern() {
        if (this.testcaseHeaderBriefPattern == null) {
            this.testcaseHeaderBriefPattern = Pattern.compile(TESTCASE_HEADER_BRIEF_REGEX);
        }
        return this.testcaseHeaderBriefPattern;
    }

    public Pattern getTestcaseHeaderPlainPattern() {
        if (this.testcaseHeaderPlainPattern == null) {
            this.testcaseHeaderPlainPattern = Pattern.compile(TESTCASE_HEADER_PLAIN_REGEX);
        }
        return this.testcaseHeaderPlainPattern;
    }

    public Pattern getTestcaseIssuePattern() {
        if (this.testcaseIssuePattern == null) {
            this.testcaseIssuePattern = Pattern.compile(TESTCASE_ISSUE_REGEX);
        }
        return this.testcaseIssuePattern;
    }

    public Pattern getTestcaseExceptionPattern() {
        if (this.testcaseExceptPattern == null) {
            this.testcaseExceptPattern = Pattern.compile(TESTCASE_EXCEPTION_REGEX);
        }
        return this.testcaseExceptPattern;
    }

    public Pattern getNestedExceptionPattern() {
        if (this.nestedExceptPattern == null) {
            this.nestedExceptPattern = Pattern.compile(NESTED_EXCEPTION_REGEX);
        }
        return this.nestedExceptPattern;
    }

    public Pattern getCallstackLinePattern() {
        if (this.callstackLinePattern == null) {
            this.callstackLinePattern = Pattern.compile(CALLSTACK_LINE_REGEX);
        }
        return this.callstackLinePattern;
    }

    public Pattern getLocationInFilePattern() {
        if (this.locationInFilePattern == null) {
            this.locationInFilePattern = Pattern.compile(LOCATION_IN_FILE_REGEX);
        }
        return this.locationInFilePattern;
    }

    public Pattern getXmlDeclPattern() {
        if (this.xmlDeclPattern == null) {
            this.xmlDeclPattern = Pattern.compile(XML_DECL_REGEX);
        }
        return this.xmlDeclPattern;
    }

    public Pattern getFloatNumPattern() {
        if (this.floatNumPattern == null) {
            this.floatNumPattern = Pattern.compile(FLOAT_NUMBER_REGEX);
        }
        return this.floatNumPattern;
    }

    public Pattern getComparisonPattern() {
        if (this.comparisonPattern == null) {
            this.comparisonPattern = Pattern.compile(COMPARISON_REGEX);
        }
        return this.comparisonPattern;
    }

    public Pattern getComparisonHiddenPattern() {
        if (this.comparisonHiddenPattern == null) {
            this.comparisonHiddenPattern = Pattern.compile(COMPARISON_HIDDEN_REGEX);
        }
        return this.comparisonHiddenPattern;
    }

    public int parseTimeMillis(String timeString) throws NumberFormatException {
        int millis;
        int secs;
        int dotIndex = timeString.indexOf(46);
        if (dotIndex == -1) {
            secs = Integer.parseInt(timeString);
            millis = 0;
        } else {
            secs = dotIndex == 0 ? 0 : Integer.parseInt(timeString.substring(0, dotIndex));
            String fractString = timeString.substring(dotIndex + 1);
            if (fractString.length() > 4) {
                fractString = fractString.substring(0, 4);
            }
            int fractNum = Integer.parseInt(fractString);
            switch (fractString.length()) {
                case 1: {
                    millis = 100 * fractNum;
                    break;
                }
                case 2: {
                    millis = 10 * fractNum;
                    break;
                }
                case 3: {
                    millis = fractNum;
                    break;
                }
                case 4: {
                    millis = (fractNum + 5) / 10;
                    break;
                }
                default: {
                    assert (false);
                    millis = 0;
                }
            }
        }
        return 1000 * secs + millis;
    }

    public int parseTimeMillisNoNFE(String timeStr) {
        if (timeStr == null || !this.getFloatNumPattern().matcher(timeStr).matches()) {
            return -1;
        }
        try {
            return this.parseTimeMillis(timeStr);
        }
        catch (NumberFormatException ex) {
            assert (false);
            return -1;
        }
    }

    public static String specialTrim(String string) {
        char c;
        int lead;
        int len = string.length();
        if (len == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        for (lead = 0; lead < len && ((c = chars[lead]) == ' ' || c == '\t'); ++lead) {
        }
        if (lead == len) {
            return string.substring(len);
        }
        int trail = len;
        while ((c = chars[--trail]) == ' ' || c == '\t') {
        }
        if (lead == 0 && trail == len - 1) {
            return string;
        }
        return string.substring(lead, trail + 1);
    }
}

