/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.modules.cnd.repository.Logger;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.disk.DoubleFileStorage;
import org.netbeans.modules.cnd.repository.disk.FileStorage;
import org.netbeans.modules.cnd.repository.disk.LayerIndex;
import org.netbeans.modules.cnd.repository.disk.RepositoryImplUtil;
import org.netbeans.modules.cnd.repository.disk.SingleFileStorage;
import org.netbeans.modules.cnd.repository.disk.index.KeysListFile;
import org.netbeans.modules.cnd.repository.impl.spi.LayerConvertersProvider;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.ReadLayerCapability;
import org.netbeans.modules.cnd.repository.impl.spi.WriteLayerCapability;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.storage.FilePathsDictionaryPersistentFactory;
import org.netbeans.modules.cnd.repository.storage.data.RepositoryDataInputStream;
import org.netbeans.modules.cnd.repository.storage.data.RepositoryDataOutputStream;
import org.netbeans.modules.cnd.repository.testbench.BaseStatistics;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public final class FilesAccessStrategyImpl
implements ReadLayerCapability,
WriteLayerCapability {
    private static final boolean TRACE_CONFLICTS = Boolean.getBoolean("cnd.repository.trace.conflicts");
    private static final long PURGE_OLD_UNITS_TIMEOUT = 1209600000L;
    private final ConcurrentHashMap<Integer, UnitStorage> unitStorageCache = new ConcurrentHashMap();
    private final URI cacheLocationURI;
    private final File cacheLocationFile;
    private final LayeringSupport layeringSupport;
    private final LayerDescriptor layerDescriptor;
    private final AtomicInteger readCnt = new AtomicInteger();
    private final AtomicInteger readHitCnt = new AtomicInteger();
    private final AtomicInteger writeCnt = new AtomicInteger();
    private final AtomicInteger writeHitCnt = new AtomicInteger();
    private final BaseStatistics<String> writeStatistics = new BaseStatistics("Writes", 2);
    private final BaseStatistics<String> readStatistics = new BaseStatistics("Reads", 2);
    private final LayerIndex layerIndex;
    private final KeysListFile removedKeysFile;
    private final String removedKeysTable = "removed-files";
    private final boolean isWritable;
    private static final java.util.logging.Logger log = Logger.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilesAccessStrategyImpl(LayerIndex layerIndex, URI cacheLocation, LayerDescriptor layerDescriptor, LayeringSupport layeringSupport) {
        this.layeringSupport = layeringSupport;
        this.layerDescriptor = layerDescriptor;
        this.layerIndex = layerIndex;
        this.cacheLocationURI = cacheLocation;
        this.cacheLocationFile = Utilities.toFile((URI)cacheLocation);
        this.isWritable = layerDescriptor.isWritable();
        KeysListFile f = null;
        FilterInputStream din = null;
        try {
            File file = new File(this.cacheLocationFile, "removed-files");
            if (file.exists()) {
                din = new RepositoryDataInputStream(RepositoryImplUtil.getBufferedDataInputStream(file), LayerConvertersProvider.getInstance((LayeringSupport)layeringSupport, (LayerDescriptor)layerDescriptor));
                f = new KeysListFile((RepositoryDataInput)din);
            }
        }
        catch (FileNotFoundException ex) {
            f = null;
        }
        catch (IOException ex) {
            f = null;
        }
        finally {
            if (din != null) {
                try {
                    din.close();
                }
                catch (IOException ex) {}
            }
        }
        KeysListFile keysListFile = this.removedKeysFile = f == null ? new KeysListFile() : f;
        if (Stats.multyFileStatistics) {
            this.resetStatistics();
        }
    }

    public void closeUnit(int unitID, boolean cleanRepository) {
        UnitStorage storage = this.unitStorageCache.remove(unitID);
        if (storage != null) {
            storage.close();
            if (cleanRepository) {
                storage.cleanUnitDirectory();
            }
        }
        if (Stats.multyFileStatistics) {
            this.printStatistics();
            this.resetStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean writable) {
        this.maintenance(Long.MAX_VALUE);
        for (Map.Entry<Integer, UnitStorage> entry : this.unitStorageCache.entrySet()) {
            this.closeUnit(entry.getKey(), false);
        }
        if (!writable) {
            return;
        }
        FilterOutputStream dos = null;
        try {
            File file = new File(this.cacheLocationFile, "removed-files");
            if (file.exists()) {
                file.delete();
            }
            dos = new RepositoryDataOutputStream(RepositoryImplUtil.getBufferedDataOutputStream(file), LayerConvertersProvider.getInstance((LayeringSupport)this.layeringSupport, (LayerDescriptor)this.layerDescriptor));
            this.removedKeysFile.write((RepositoryDataOutput)dos);
        }
        catch (FileNotFoundException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException ex) {
                    RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                }
            }
        }
    }

    public void remove(LayerKey key, boolean hasReadOnlyLayersInStorage) {
        if (hasReadOnlyLayersInStorage) {
            this.removedKeysFile.put(key);
        }
        UnitStorage unitStorage = this.getUnitStorage(key.getUnitId());
        unitStorage.remove(key);
    }

    void testCloseUnit(int unitId) throws IOException {
        this.closeUnit(unitId, false);
    }

    void printStatistics() {
        System.out.printf("\nFileAccessStrategy statistics: reads %d hits %d (%d%%) writes %d hits %d (%d%%)\n", this.readCnt.get(), this.readHitCnt.get(), FilesAccessStrategyImpl.percentage(this.readHitCnt.get(), this.readCnt.get()), this.writeCnt.get(), this.writeHitCnt.get(), FilesAccessStrategyImpl.percentage(this.writeHitCnt.get(), this.writeCnt.get()));
        if (this.writeStatistics != null) {
            this.readStatistics.print(System.out);
        }
        if (this.writeStatistics != null) {
            this.writeStatistics.print(System.out);
        }
    }

    private static int percentage(int numerator, int denominator) {
        return denominator == 0 ? 0 : numerator * 100 / denominator;
    }

    private void resetStatistics() {
        this.writeStatistics.clear();
        this.readStatistics.clear();
        this.readCnt.set(0);
        this.readHitCnt.set(0);
        this.writeCnt.set(0);
        this.writeHitCnt.set(0);
    }

    private static String getBriefClassName(Object o) {
        if (o == null) {
            return "null";
        }
        String name = o.getClass().getName();
        int pos = name.lastIndexOf(46);
        return pos < 0 ? name : name.substring(pos + 1);
    }

    public String toString() {
        return "FilesAccessStrategyImpl: " + this.cacheLocationURI.toString();
    }

    public boolean knowsKey(LayerKey key) {
        UnitStorage unitStorage = this.getUnitStorage(key.getUnitId());
        FileStorage fileStorage = unitStorage.getFileStorage(key, this.isWritable);
        if (fileStorage == null) {
            return false;
        }
        try {
            return fileStorage.hasKey(key);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ByteBuffer read(LayerKey key) {
        this.readCnt.incrementAndGet();
        if (Stats.multyFileStatistics) {
            this.readStatistics.consume(FilesAccessStrategyImpl.getBriefClassName(key), 1);
        }
        if (this.removedKeysFile.keySet().contains(key)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " the key with unit id:{0} and behaviour: {1} is removed from the layer, will not read from the disk", new Object[]{key.getUnitId(), key.getBehavior()});
            }
            return null;
        }
        UnitStorage unitStorage = this.getUnitStorage(key.getUnitId());
        FileStorage fileStorage = unitStorage.getFileStorage(key, this.isWritable);
        try {
            if (fileStorage != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Storage is found for the key with unit id:{0} and behaviour: {1} is ", new Object[]{key.getUnitId(), key.getBehavior()});
                }
                return fileStorage.read(key);
            }
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)ex);
        }
        return null;
    }

    public void write(LayerKey key, ByteBuffer data) {
        this.writeCnt.incrementAndGet();
        if (Stats.multyFileStatistics) {
            this.writeStatistics.consume(FilesAccessStrategyImpl.getBriefClassName(key), 1);
        }
        UnitStorage unitStorage = this.getUnitStorage(key.getUnitId());
        FileStorage fileStorage = unitStorage.getFileStorage(key, true);
        try {
            if (fileStorage != null) {
                fileStorage.write(key, data);
            }
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)ex);
        }
    }

    public void removeUnit(int unitIDInLayer) {
        this.layerIndex.removeUnit(unitIDInLayer);
        UnitStorage unitStorage = this.getUnitStorage(unitIDInLayer);
        unitStorage.cleanUnitDirectory();
    }

    int getReadHitCnt() {
        return this.readHitCnt.get();
    }

    int getReadHitPercentage() {
        return FilesAccessStrategyImpl.percentage(this.readHitCnt.get(), this.readCnt.get());
    }

    int getWriteHitCnt() {
        return this.writeHitCnt.get();
    }

    int getWriteHitPercentage() {
        return FilesAccessStrategyImpl.percentage(this.writeHitCnt.get(), this.writeCnt.get());
    }

    public void debugDump(LayerKey key) {
        UnitStorage unitStorage = this.getUnitStorage(key.getUnitId());
        unitStorage.debugDump(key);
    }

    public boolean maintenance(long timeout) {
        if (Stats.traceDefragmentation) {
            System.out.println("-------layer " + this.cacheLocationURI + " start defragmenting------");
        }
        UnitStorage[] values = this.unitStorageCache.values().toArray(new UnitStorage[0]);
        Arrays.sort(values, new MaintenanceStorageComparator());
        long start = System.currentTimeMillis();
        long rest = timeout;
        boolean needMoreTime = false;
        int counter = 0;
        int storagesCount = values.length;
        for (UnitStorage storage : values) {
            ++counter;
            int weight = 0;
            try {
                weight = storage.dblStorage.isOpened() ? storage.dblStorage.getFragmentationPercentage() : 0;
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
            if (weight < Stats.defragmentationThreashold) {
                return needMoreTime;
            }
            needMoreTime = storage.maintenance(rest);
            rest = timeout - (System.currentTimeMillis() - start);
            if (rest > 0L || counter >= storagesCount) continue;
            needMoreTime = true;
            break;
        }
        return needMoreTime;
    }

    private UnitStorage getUnitStorage(int unitID) {
        UnitStorage result = this.unitStorageCache.get(unitID);
        if (result == null) {
            result = new UnitStorage(this.cacheLocationFile, this.layerDescriptor, this.layeringSupport, unitID);
            this.unitStorageCache.put(unitID, result);
        }
        return result;
    }

    public int registerNewUnit(UnitDescriptor unitDescriptor) {
        return this.layerIndex.registerUnit(unitDescriptor);
    }

    public int registerClientFileSystem(FileSystem fileSystem) {
        return this.layerIndex.registerFileSystem(fileSystem);
    }

    Collection<LayerKey> removedTableKeySet() {
        return this.removedKeysFile.keySet();
    }

    public int getMaintenanceWeight() throws IOException {
        int weight = 0;
        for (UnitStorage storage : this.unitStorageCache.values()) {
            weight += storage.dblStorage.isOpened() ? storage.dblStorage.getFragmentationPercentage() : 0;
        }
        return weight;
    }

    private static class MaintenanceStorageComparator
    implements Comparator<UnitStorage>,
    Serializable {
        private MaintenanceStorageComparator() {
        }

        @Override
        public int compare(UnitStorage storage1, UnitStorage storage2) {
            try {
                int weight1 = storage1.dblStorage.isOpened() ? storage1.dblStorage.getFragmentationPercentage() : 0;
                int weight2 = storage2.dblStorage.isOpened() ? storage2.dblStorage.getFragmentationPercentage() : 0;
                return weight2 - weight1;
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                return 0;
            }
        }
    }

    private static class UnitStorage {
        private final DoubleFileStorage dblStorage;
        private final SingleFileStorage singleStorage;
        private final File baseDir;

        private UnitStorage(File cacheLocationFile, LayerDescriptor layerDescriptor, LayeringSupport layeringSupport, int unitID) {
            this.baseDir = new File(cacheLocationFile, "" + unitID);
            this.dblStorage = new DoubleFileStorage(this.baseDir, layerDescriptor, layeringSupport);
            this.singleStorage = new SingleFileStorage(this.baseDir);
        }

        private void close() {
            try {
                this.dblStorage.close();
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
        }

        private FileStorage getFileStorage(LayerKey key, boolean forWriting) {
            FileStorage storage = Key.Behavior.LargeAndMutable.equals((Object)key.getBehavior()) ? this.singleStorage : this.dblStorage;
            if (!storage.open(forWriting)) {
                return null;
            }
            return storage;
        }

        private void remove(LayerKey key) {
            FileStorage fileStorage = this.getFileStorage(key, true);
            try {
                if (fileStorage != null) {
                    fileStorage.remove(key);
                }
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
        }

        private void debugDump(LayerKey key) {
            this.dblStorage.debugDump(key);
        }

        private boolean maintenance(long timeout) {
            try {
                return this.dblStorage.maintenance(timeout);
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                return false;
            }
        }

        public String toString() {
            return "UnitStorage: " + this.dblStorage + " & " + this.singleStorage;
        }

        private void cleanUnitDirectory() {
            ArrayList<String> excludedNames = new ArrayList<String>();
            try {
                excludedNames.add(FilePathsDictionaryPersistentFactory.getFilePathsDictionaryKeyFileName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RepositoryImplUtil.deleteDirectory(this.baseDir, excludedNames, false);
        }
    }
}

