/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.disk.RepositoryImplUtil;
import org.netbeans.modules.cnd.repository.disk.UnitDescriptorsListImpl;
import org.netbeans.modules.cnd.repository.impl.spi.UnitDescriptorsList;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public final class LayerIndex {
    private final File cacheDirectoryFile;
    private int version;
    private static final String INDEX_FILE_NAME = "index";
    private long lastModificationTime;
    private final List<FileSystem> fileSystems = new ArrayList<FileSystem>();
    private final UnitDescriptorsListImpl units = new UnitDescriptorsListImpl();
    private final Map<Integer, List<Integer>> dependencies = new HashMap<Integer, List<Integer>>();

    LayerIndex(URI cacheDirectory) {
        this.cacheDirectoryFile = Utilities.toFile((URI)cacheDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean load(int persistMechanismVersion, boolean recreate, boolean recreateOnFail) {
        this.version = persistMechanismVersion;
        File indexFile = new File(this.cacheDirectoryFile, INDEX_FILE_NAME);
        if (recreate) {
            return this.clearDataImpl();
        }
        if (!indexFile.exists() && recreateOnFail) {
            return this.clearDataImpl();
        }
        DataInputStream in = null;
        try {
            int i;
            in = RepositoryImplUtil.getBufferedDataInputStream(indexFile);
            int storedVersion = in.readInt();
            if (storedVersion != persistMechanismVersion) {
                if (recreateOnFail) {
                    boolean bl = this.clearDataImpl();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            this.lastModificationTime = in.readLong();
            int unitsCount = in.readInt();
            int unitsMax = in.readInt();
            this.units.setMaxValue(unitsMax);
            int fileSystemsCount = in.readInt();
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                this.trace("Reading master index (%d) units\n", unitsCount);
                this.trace("Reading master index (%d) fileSystems\n", fileSystemsCount);
            }
            for (i = 0; i < fileSystemsCount; ++i) {
                String fs = in.readUTF();
                this.fileSystems.add(CndFileUtils.decodeFileSystem((CharSequence)fs));
            }
            for (i = 0; i < unitsCount; ++i) {
                int unitID = in.readInt();
                String unitName = in.readUTF();
                int fsIdx = in.readInt();
                long unitModificationTime = in.readLong();
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    this.trace("\tRead %d@%s@%s ts=%d\n", unitID, unitName, this.fileSystems.get(fsIdx), unitModificationTime);
                }
                this.units.addUnitDescriptor(unitID, new UnitDescriptor((CharSequence)unitName, this.fileSystems.get(fsIdx)));
                ArrayList<Integer> depList = new ArrayList<Integer>();
                int depListSize = in.readInt();
                for (int j = 0; j < depListSize; ++j) {
                    unitID = in.readInt();
                    long ts = in.readLong();
                    depList.add(unitID);
                }
                this.dependencies.put(unitID, depList);
            }
            if (this.checkConsistency()) {
                boolean bl = true;
                return bl;
            }
            CndUtils.assertTrueInConsole((boolean)false, (String)"corrupted load of repository index", (Object)this.toString());
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    RepositoryExceptions.throwException((Object)this, (Throwable)ex);
                }
            }
            if (recreateOnFail && !indexFile.delete()) {
                System.err.println("Cannot delete repository index File " + indexFile.getAbsolutePath());
            }
        }
        if (recreateOnFail) {
            return this.clearDataImpl();
        }
        return false;
    }

    private boolean clearDataImpl() {
        if (this.cacheDirectoryFile.canWrite()) {
            RepositoryImplUtil.deleteDirectory(this.cacheDirectoryFile, false);
            this.fileSystems.clear();
            this.units.clear();
            this.dependencies.clear();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws IOException {
        long currentTime = System.currentTimeMillis();
        File indexFile = new File(this.cacheDirectoryFile, INDEX_FILE_NAME);
        DataOutputStream out = null;
        try {
            out = RepositoryImplUtil.getBufferedDataOutputStream(indexFile);
            out.writeInt(this.version);
            out.writeLong(currentTime);
            Map<UnitDescriptor, Integer> map = this.units.getMap();
            int unitsCount = map.size();
            out.writeInt(unitsCount);
            out.writeInt(this.units.getMaxValue());
            int fileSystemsCount = this.fileSystems.size();
            out.writeInt(fileSystemsCount);
            for (int i = 0; i < fileSystemsCount; ++i) {
                out.writeUTF(CndFileUtils.codeFileSystem((FileSystem)this.fileSystems.get(i)).toString());
            }
            for (Map.Entry<UnitDescriptor, Integer> entry : map.entrySet()) {
                int unitID = entry.getValue();
                UnitDescriptor ud = entry.getKey();
                out.writeInt(unitID);
                out.writeUTF(ud.getName().toString());
                out.writeInt(this.fileSystems.indexOf(ud.getFileSystem()));
                out.writeLong(currentTime);
                List<Integer> depMap = this.dependencies.get(unitID);
                out.writeInt(depMap == null ? 0 : depMap.size());
                if (depMap == null) continue;
                for (Integer depID : depMap) {
                    out.writeInt(depID);
                    out.writeLong(currentTime);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void trace(String format, Object ... args) {
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = System.currentTimeMillis();
        System.arraycopy(args, 0, newArgs, 1, args.length);
        System.err.printf("MasterIndex [%d] " + format, newArgs);
    }

    UnitDescriptorsList getUnitsTable() {
        return this.units;
    }

    List<FileSystem> getFileSystemsTable() {
        return Collections.unmodifiableList(this.fileSystems);
    }

    int registerUnit(UnitDescriptor unitDescriptor) {
        int unitID = this.units.registerNewUnitDescriptor(unitDescriptor);
        return unitID;
    }

    void removeUnit(int unitIDInLayer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int registerFileSystem(FileSystem fileSystem) {
        List<FileSystem> list = this.fileSystems;
        synchronized (list) {
            int index = this.fileSystems.indexOf(fileSystem);
            if (index == -1) {
                index = this.fileSystems.size();
                this.fileSystems.add(fileSystem);
            }
            return index;
        }
    }

    void closeUnit(int unitIdx, boolean cleanRepository, Set<Integer> requiredUnits) {
        this.dependencies.put(unitIdx, requiredUnits == null ? new ArrayList() : new ArrayList<Integer>(requiredUnits));
    }

    private boolean checkConsistency() {
        Collection<Integer> unitIDs = this.units.getUnitIDs();
        for (Integer unit : unitIDs) {
            if (unit == null || unit < 0) {
                return false;
            }
            for (Integer dep : this.dependencies.get(unit)) {
                if (dep == null || dep < 0) {
                    return false;
                }
                if (unitIDs.contains(dep)) continue;
                return false;
            }
        }
        for (FileSystem fileSystem : this.fileSystems) {
            if (fileSystem != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "LayerIndex{cacheDirectoryFile=" + this.cacheDirectoryFile + "\n, version=" + this.version + ", lastModificationTime=" + this.lastModificationTime + "\n, fileSystems=" + this.fileSystems + "\n, units=" + this.units + "\n, dependencies=" + this.dependencies + '}';
    }
}

