/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.ChangeParametersFix;
import org.netbeans.modules.java.hints.errors.CreateElement;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class ChangeMethodParameters
implements ErrorRule<Void> {
    private String DEFAULT_NAME = "par";
    private boolean cancel = false;

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbol.1", "compiler.err.cant.apply.symbols", "compiler.err.prob.found.req"));
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            this.cancel = false;
            return this.analyze(info, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public String getId() {
        return ChangeMethodParameters.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_ChangeMethodParameters");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateElement.class, (String)"DSC_ChangeMethodParameters");
    }

    public void cancel() {
        this.cancel = true;
    }

    private List<Fix> analyze(CompilationInfo info, int offset) throws IOException {
        LinkedList<Fix> fixes;
        block15: {
            Tree error;
            TreePath errorPath;
            block14: {
                Object method;
                errorPath = ErrorHintsProvider.findUnresolvedElement(info, offset);
                if (errorPath == null || errorPath.getParentPath() == null) {
                    return Collections.emptyList();
                }
                error = errorPath.getParentPath().getLeaf();
                if (error == null) {
                    return Collections.emptyList();
                }
                if (info.getElements().getTypeElement("java.lang.Object") == null) {
                    return Collections.emptyList();
                }
                fixes = new LinkedList<Fix>();
                if (error.getKind() != Tree.Kind.METHOD_INVOCATION) break block14;
                MethodInvocationTree invocation = (MethodInvocationTree)error;
                if (!invocation.getMethodSelect().getKind().equals((Object)Tree.Kind.IDENTIFIER)) break block15;
                TreePath enclosingTypePath = this.findEnclosingType(errorPath.getParentPath());
                List<? extends ExpressionTree> arguments = invocation.getArguments();
                Pair<List<? extends TypeMirror>, List<String>> formalArguments = Utilities.resolveArguments(info, errorPath.getParentPath(), arguments, info.getTrees().getElement(enclosingTypePath));
                if (formalArguments == null) {
                    return Collections.emptyList();
                }
                IdentifierTree methodSelect = (IdentifierTree)invocation.getMethodSelect();
                LinkedList<TreePath> methods = new LinkedList<TreePath>();
                for (Tree tree : ((ClassTree)enclosingTypePath.getLeaf()).getMembers()) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    if (!tree.getKind().equals((Object)Tree.Kind.METHOD) || !(method = (MethodTree)tree).getName().contentEquals(methodSelect.getName())) continue;
                    methods.add(new TreePath(enclosingTypePath, (Tree)method));
                }
                for (TreePath treePath : methods) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    method = (ExecutableElement)info.getTrees().getElement(treePath);
                    if (this.createFixes(info, arguments, treePath, enclosingTypePath, (ExecutableElement)method, fixes)) continue;
                    return Collections.emptyList();
                }
                break block15;
            }
            if (error.getKind() == Tree.Kind.NEW_CLASS) {
                NewClassTree invocation = (NewClassTree)error;
                TreePath enclosingTypePath = this.findEnclosingType(errorPath.getParentPath());
                if (enclosingTypePath == null) {
                    return Collections.emptyList();
                }
                Element element = info.getTrees().getElement(new TreePath(errorPath, invocation.getIdentifier()));
                Element enclosingType = info.getTrees().getElement(enclosingTypePath);
                if (element != null && element.equals(enclosingType)) {
                    List<? extends ExpressionTree> arguments = invocation.getArguments();
                    Pair<List<? extends TypeMirror>, List<String>> formalArguments = Utilities.resolveArguments(info, errorPath.getParentPath(), arguments, info.getTrees().getElement(enclosingTypePath));
                    if (formalArguments == null) {
                        return Collections.emptyList();
                    }
                    for (ExecutableElement executableElement : ElementFilter.constructorsIn(((TypeElement)enclosingType).getEnclosedElements())) {
                        if (this.cancel) {
                            return Collections.emptyList();
                        }
                        TreePath path = info.getTrees().getPath(executableElement);
                        if (path == null || this.createFixes(info, arguments, path, enclosingTypePath, executableElement, fixes)) continue;
                        return Collections.emptyList();
                    }
                }
            }
        }
        return fixes;
    }

    private static String makeNameUnique(CompilationInfo info, Scope s, String name, ChangeParametersRefactoring.ParameterInfo[] parameters, int current) {
        int counter = 0;
        boolean cont = true;
        String proposedName = name;
        block0: while (cont) {
            proposedName = name + (counter != 0 ? String.valueOf(counter) : "");
            cont = false;
            if (s != null) {
                for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new Utilities.VariablesFilter())) {
                    if (!proposedName.equals(e.getSimpleName().toString())) continue;
                    ++counter;
                    cont = true;
                    break;
                }
            }
            for (int i = 0; i < parameters.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo parameterInfo = parameters[i];
                if (current == i || parameterInfo == null || !proposedName.equals(parameterInfo.getName())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        }
        return proposedName;
    }

    public String genDeclarationString(TypeElement typeElement, MethodTree methodTree, ChangeParametersRefactoring.ParameterInfo[] parameters) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getMethodName(methodTree, typeElement));
        buf.append('(');
        if (parameters.length > 0) {
            int i;
            for (i = 0; i < parameters.length - 1; ++i) {
                buf.append(parameters[i].getType());
                buf.append(' ');
                buf.append(parameters[i].getName());
                buf.append(',').append(' ');
            }
            buf.append(parameters[i].getType());
            buf.append(' ');
            buf.append(parameters[i].getName());
        }
        buf.append(')');
        return buf.toString();
    }

    private TreePath findEnclosingType(TreePath parentPath) {
        for (TreePath klazz = parentPath; klazz != null; klazz = klazz.getParentPath()) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)klazz.getLeaf().getKind())) continue;
            return klazz;
        }
        return null;
    }

    private ChangeParametersRefactoring.ParameterInfo findNextByType(CompilationInfo info, ChangeParametersRefactoring.ParameterInfo[] parameterInfo, String type, TypeElement scopeType) {
        for (int i = 0; i < parameterInfo.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo param = parameterInfo[i];
            if (param.getOriginalIndex() <= -1 || !this.isSameType(info, type, param.getType(), scopeType)) continue;
            parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(-1, param.getName(), param.getType(), null);
            return param;
        }
        return null;
    }

    private boolean isSameType(CompilationInfo info, String from, String to, TypeElement scopeType) {
        if (from.equals(to)) {
            return true;
        }
        Element fromElement = info.getTypes().asElement(info.getTreeUtilities().parseType(from, scopeType));
        Element toElement = info.getTypes().asElement(info.getTreeUtilities().parseType(to, scopeType));
        if (fromElement != null && toElement != null) {
            if (!(fromElement.getKind().isClass() || fromElement.getKind().isInterface() || fromElement.getKind().isField())) {
                return false;
            }
            if (!(toElement.getKind().isClass() || toElement.getKind().isInterface() || toElement.getKind().isField())) {
                return false;
            }
            TypeElement fromType = (TypeElement)fromElement;
            TypeElement toType = (TypeElement)toElement;
            return info.getTypes().isSubtype(fromType.asType(), toType.asType());
        }
        return false;
    }

    private boolean createFixes(CompilationInfo info, List<? extends ExpressionTree> arguments, TreePath path, TreePath enclosingTypePath, ExecutableElement method, LinkedList<Fix> fixes) throws IllegalArgumentException {
        if (method == null) {
            return false;
        }
        List<? extends VariableElement> parameters = method.getParameters();
        ChangeParametersRefactoring.ParameterInfo[] parameterInfo = new ChangeParametersRefactoring.ParameterInfo[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement param2 = parameters.get(i);
            VariableTree parTree = (VariableTree)info.getTrees().getTree(param2);
            parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(i, param2.toString(), parTree.getType().toString(), null);
        }
        ChangeParametersRefactoring.ParameterInfo[] newParameterInfo = new ChangeParametersRefactoring.ParameterInfo[arguments.size()];
        MethodTree methodTree = (MethodTree)path.getLeaf();
        BlockTree methodBody = methodTree.getBody();
        Scope scope = null;
        if (methodBody != null) {
            TreePath bodyPath = new TreePath(path, methodBody);
            scope = info.getTrees().getScope(bodyPath);
        } else {
            scope = info.getTrees().getScope(path);
        }
        int i = 0;
        for (ExpressionTree expressionTree : arguments) {
            if (this.cancel) {
                return false;
            }
            TreePath argumentPath = new TreePath(path, expressionTree);
            TypeMirror argumentType = info.getTrees().getTypeMirror(argumentPath);
            String type = argumentType.toString();
            String name = org.netbeans.modules.editor.java.Utilities.varNameSuggestion((TreePath)argumentPath);
            if (name == null) {
                name = this.DEFAULT_NAME;
            }
            name = ChangeMethodParameters.makeNameUnique(info, scope, name, newParameterInfo, i);
            newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(-1, name, type, expressionTree.toString());
            ++i;
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(enclosingTypePath);
        for (i = 0; i < newParameterInfo.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo parameterInfo2;
            ChangeParametersRefactoring.ParameterInfo next;
            if (this.cancel) {
                return false;
            }
            if (typeElement == null || (next = this.findNextByType(info, parameterInfo, (parameterInfo2 = newParameterInfo[i]).getType(), typeElement)) == null) continue;
            newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(next.getOriginalIndex(), next.getName(), next.getType(), parameterInfo2.getDefaultValue());
        }
        for (i = 0; i < newParameterInfo.length; ++i) {
            if (this.cancel) {
                return false;
            }
            ChangeParametersRefactoring.ParameterInfo parameterInfo3 = newParameterInfo[i];
            TypeMirror type = info.getTreeUtilities().parseType(parameterInfo3.getType(), typeElement);
            String typeString = org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)type, (boolean)false).toString();
            newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(parameterInfo3.getOriginalIndex(), parameterInfo3.getName(), typeString, parameterInfo3.getDefaultValue());
        }
        for (i = 0; i < newParameterInfo.length; ++i) {
            if (this.cancel) {
                return false;
            }
            ChangeParametersRefactoring.ParameterInfo parameterInfo4 = newParameterInfo[i];
            if (parameterInfo4.getOriginalIndex() != -1 || parameterInfo.length <= i || parameterInfo[i].getOriginalIndex() == -1) continue;
            newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(parameterInfo[i].getOriginalIndex(), parameterInfo[i].getName(), parameterInfo4.getType(), parameterInfo4.getDefaultValue());
        }
        TreePathHandle treePathHandle = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
        boolean doFullRefactoring = true;
        if (methodTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
            doFullRefactoring = false;
        }
        Set<Modifier> modifiers = method.getModifiers();
        fixes.add(new ChangeParametersFix(doFullRefactoring, treePathHandle, modifiers, this.genDeclarationString(typeElement, methodTree, parameterInfo), this.genDeclarationString(typeElement, methodTree, newParameterInfo), newParameterInfo, method.getKind() == ElementKind.CONSTRUCTOR));
        return true;
    }

    private String getMethodName(MethodTree methodTree, TypeElement typeElement) {
        String name = methodTree.getName().toString();
        if (name.equals("<init>")) {
            name = typeElement.getSimpleName().toString();
        }
        return name;
    }
}

